import sys
import commonroad_reach.utility.logger as util_logger
from commonroad_reach.data_structure.configuration_builder import ConfigurationBuilder
from commonroad_reach.data_structure.reach.reach_interface import ReachableSetInterface
from commonroad_reach.utility import visualization as util_visual


def main():
    # ==== specify scenario
    # name_scenario = "DEU_Test-1_1_T-1"
    # name_scenario = "ZAM_Over-1_1"
    # name_scenario = "ARG_Carcarana-1_1_T-1"
    # name_scenario = "USA_US101-6_1_T-1"
    # name_scenario = "ZAM_Intersection-1_1_T-1"
    name_scenario = sys.argv[1]
    # ==== build configuration
    config = ConfigurationBuilder.build_configuration(name_scenario)
    config.update(list_ids_lanelets=[25])
    util_logger.initialize_logger(config)
    config.print_configuration_summary()

    # ==== compute reachable sets using reachability interface
    reach_interface = ReachableSetInterface(config)
    reach_interface.compute_reachable_sets()
    print(reach_interface.step_start,reach_interface.step_end)
    # print(len(reach_interface.reachable_set_at_step(reach_interface.step_end)))
    # for i in range(reach_interface.step_start,reach_interface.step_end):
    #     print(len(reach_interface.reachable_set_at_step(i)))
    #     print(reach_interface.reachable_set_at_step(i)[0].p_lon_max())
    #     print(reach_interface.reachable_set_at_step(i)[0].p_lon_min())
    #     print(reach_interface.reachable_set_at_step(i)[0].p_lat_max())
    #     print(reach_interface.reachable_set_at_step(i)[0].p_lat_min())

    # ==== plot computation results
    util_visual.plot_scenario_with_reachable_sets(reach_interface)


if __name__ == "__main__":
    main()
