#include "modules/controlGT/control_gt_core.h"
#include "cyber/init.h"
#include "cyber/cyber.h"
#include <stdlib.h>
using apollo::controlGT::ControlGTCore;

int main(int argc, char** argv) {
    apollo::cyber::Init("controlGT");
    AINFO << "Start "<<argv[0];
    double initial_speed=0.0;
    if (argc > 2){
        initial_speed = std::hypot(atof(argv[1]),atof(argv[2]));
        AERROR << initial_speed;
    }
    char * log_file="trajectory_log.txt";
    if (argc > 3){
        log_file = argv[3];
    }
    bool is_enable_prediction_gt = false;
    if (argc > 4){
        if (strcmp(argv[4],"prediction_gt")==0){
            is_enable_prediction_gt = true;
        }
    }
    AERROR << argv[4]<<" is_enable_prediction_gt = "<<is_enable_prediction_gt;
    ControlGTCore controlGTCore(log_file,is_enable_prediction_gt);
    controlGTCore.Start(initial_speed);
    apollo::cyber::WaitForShutdown();
    AINFO << "exit controlGT.";
    return 0;
}
