#!/usr/bin/env python3
# Convert LaneFollow to Waypoint Seed

import click
import os, sys
import copy
import tempfile
import json

sys.path.append(os.path.join(os.path.expanduser('~'), "AD-Fuzzer"))

import dataparser as _Parser
from dataparser.scenario import WayPoint, NPCBehaviour
from run_vse import VSERunner


class LF2WPConverter:
    def __init__(self, _seed):
        # return
        self.scenario = _Parser.scenario_parser(_seed)

    def run_once(self):
        with tempfile.TemporaryDirectory() as tmpdirname:
            os.mkdir(tmpdirname + "/collision")
            vse_runner = VSERunner(self.scenario, tmpdirname, 'none', _sensor_conf="b48d5dd1-0aa5-426c-9868-bcf88168fa85")
            # vse_runner = VSERunner(self.scenario, tmpdirname, 'none', _sensor_conf="0351d347-07be-4236-845f-06501006090e")
            # vse_runner = VSERunner(self.scenario, tmpdirname, 'none', _sensor_conf="de129207-1167-46ef-93a2-9bc0a3f0628b")
            vse_runner.run(60)
    
    def convert(self):
        self.run_once()
        # os.system("sleep 1 && mv ~/.config/unity3d/LGElectronics/SVLSimulator-2021.2.2/in.txt.gz /tmp")
        os.system("sleep 1 && mv ~/Build_Local/2021.2-wise/in.txt.gz /tmp")
        os.system("sleep 3 && gunzip -f /tmp/in.txt.gz")

        f = open("/tmp/in.txt", 'r')

        npc_dict = dict()

        tmp_buf = f.readline()
        while tmp_buf:
            tmp_obj = json.loads(tmp_buf)

            if type(tmp_obj) is list:
                if len(tmp_obj) != 0:
                    for npc in tmp_obj:
                        id = npc["Id"]
                        wp = dict(Position=npc["Position"], Rotation=npc["Rotation"], Speed=npc["LinearVelocity"]["x"])

                        if id in npc_dict:
                            npc_dict[id].append(wp)
                        else:
                            npc_dict[id] = [wp]
            
            tmp_buf = f.readline()

        f.close()
        # print(npc_dict[20])

        NPC = copy.deepcopy(self.scenario.elements["npc"])
        for npc in NPC:
            print(npc.transform.position, npc.transform.rotation)
        # PED = copy.deepcopy(self.scenario.elements["pedestrian"])
        # for ped in PED:
        #     print(ped.transform.position, ped.transform.rotation)
        
        for id in npc_dict:
            logging_npc = npc_dict[id][0]
            print(id, logging_npc)

            gt_idx = -1
            for idx in range(len(NPC)):
                # if logging_npc["Position"]["x"] == npc.transform.position["x"] and logging_npc["Position"]["y"] == npc.transform.position["y"] and logging_npc["Position"]["z"] == npc.transform.position["z"]:
                if (abs(logging_npc["Position"]["x"] - NPC[idx].transform.position["x"])) < 0.5:
                    gt_idx = idx
                    break

            if gt_idx >= 0:
                num = 0
                out_wp = []
                for wp in npc_dict[id]:
                    outx = WayPoint(dict(
                        ordinalNumber=num,
                        position=dict(x=wp["Position"]["x"], y=wp["Position"]["y"], z=wp["Position"]["z"]),
                        angle=dict(x=wp["Rotation"]["x"], y=wp["Rotation"]["y"], z=wp["Rotation"]["z"]),
                        waitTime=0.0,
                        speed=wp["Speed"],
                        trigger=dict(effectors=[])                            
                    ))
                    num += 1
                    out_wp.append(outx)
                
                if NPC[gt_idx].behaviour.name != "NPCWaypointBehaviour":
                    NPC[gt_idx].behaviour = NPCBehaviour(dict(name="NPCWaypointBehaviour"))
                    NPC[gt_idx].wayPoints = []
                    for wayPoint in out_wp:
                        NPC[gt_idx].wayPoints.append(wayPoint)
            #     continue

            # for idx in range(len(PED)):
            #     if (abs(logging_npc["Position"]["x"] - PED[idx].transform.position["x"])) < 0.5:
            #         gt_idx = idx
            #         exit(-1)
            #         break

            # if gt_idx >= 0:
            #     num = 0
            #     out_wp = []
            #     for wp in npc_dict[id]:
            #         wp["Speed"] = abs(wp["Speed"])
            #         if wp["Speed"] == 0:
            #             wp["Speed"] = 0.01
            #         outx = WayPoint(dict(
            #             ordinalNumber=num-130,
            #             position=dict(x=wp["Position"]["x"], y=wp["Position"]["y"], z=wp["Position"]["z"]),
            #             angle=dict(x=wp["Rotation"]["x"], y=wp["Rotation"]["y"], z=wp["Rotation"]["z"]),
            #             waitTime=0.0,
            #             speed=wp["Speed"],
            #             acceleration=0
            #         ))
            #         num += 1
            #         if num <= 130:
            #             continue
            #         out_wp.append(outx)
            #     out_wp[0].waitTime = 12.1
            #     PED[gt_idx].wayPoints = []
            #     for wayPoint in out_wp:
            #         PED[gt_idx].wayPoints.append(wayPoint)
            else:
                print("NPC not found in the seed!")
        
        self.new_scenario = copy.deepcopy(self.scenario)
        self.new_scenario.elements["npc"] = NPC
        # self.new_scenario.elements["pedestrian"] = PED

        self.new_scenario.to_json()
        self.new_scenario.store("/tmp/new.txt")

        return self.new_scenario
                        

@click.command()
@click.option(
    "-i",
    "--input",
    type=click.Path(dir_okay=False, exists=True),
    required=True,
    help="input test case to be proceeded by the tool",
)
@click.option(
    "-o",
    "--output",
    type=click.Path(dir_okay=False, exists=False),
    required=True,
    help="final output location for the converted seed",
)
def main(input, output):
    """A tool that converts LaneFollow to Waypoint seed."""
    converter = LF2WPConverter(input)
    new_seed = converter.convert()
    new_seed.store(output)

    os.system("rm -rf /tmp/new.txt /tmp/in.txt")


if __name__ == "__main__":
    main()
