#!/usr/bin/zsh
unset PYTHONPATH
source /opt/ros/melodic/setup.zsh
source $HOME/src/repos/autoware.ai/messages/devel/setup.zsh
source $HOME/src/repos/autoware.ai/autoware.ai.openplanner/devel/setup.zsh
source $HOME/carla-autoware/devel/setup.zsh
#source $HOME/src/repos/autoware.ai/autoware-1.14.0/install/setup.zsh
export AUTOWARE_FUZZER=${0:a:h}
if [ "$CARLA_AUTOWARE_CONTENTS" = "" ];then
    export CARLA_AUTOWARE_CONTENTS=$HOME/shared_dir/autoware-data
fi

export CARLA_SCENARIO_RUNNER=$HOME/scenario_runner
# export CARLA_ROOT_ORI=$HOME/carla_release/carla-0.9.12
export CARLA_ROOT=$HOME/carla_release/carla-0.9.13
export SCENARIO_RUNNER_ROOT=$HOME/scenario_runner
#export SCENARIO_RUNNER_ROOT=$HOME/src/repos/carla_srunner/scenario_runner-0.9.12
export PYTHONPATH=$PYTHONPATH:${CARLA_ROOT}/PythonAPI/carla/agents
export PYTHONPATH=$PYTHONPATH:${CARLA_ROOT}/PythonAPI/carla
export PYTHONPATH=$PYTHONPATH:${CARLA_ROOT}/PythonAPI

export PYTHONPATH=$PYTHONPATH:$AUTOWARE_FUZZER
export PYTHONPATH=$PYTHONPATH:$CARLA_SCENARIO_RUNNER

export PYTHON2CARLA=$CARLA_ROOT/PythonAPI/carla/dist/carla-0.9.13-py2.7-linux-x86_64.egg
export PYTHON3CARLA=$CARLA_ROOT/PythonAPI/carla/dist/carla-0.9.13-py3.7-linux-x86_64.egg

# export PYTHONPATH=$PYTHONPATH:$PYTHON3CARLA

unalias ftest
alias ftest="python3 $AUTOWARE_FUZZER/tools/run_openscenario_test.py --waitForEgo"

unalias getmap
getmap () {
    xmllint --xpath 'string(//LogicFile/@filepath)' $1
}