#!/bin/bash

function clean(){
	pids=`ps -ef | grep $1 | awk '{print $2}'`
	for pid in $pids
	do
		echo $pid
        kill -9 $pid
	done
}

dir=$PWD
seed_dir=$dir/$1
seed=`find $seed_dir/normal_collision -maxdepth 1 -type f`

# simulatorpath=$HOME/Build/Simulator/
simulatorpath=$HOME/simulatorBuild/
mkdir -p $seed_dir/wp_collision
mkdir -p $seed_dir/tmin_collision
mkdir -p $seed_dir/collision_data

# rosnode kill -a

# clean the environment
rosnode kill -a
clean bridge
clean planner
pkill -P $$ --signal 9
clean bridge
sleep 1

# restart envrionment
killall -9 $simulatorpath/simulator >& /dev/null
DISPLAY=:0 $simulatorpath/simulator &
sleep 10
python3 $AUTOWARE_FUZZER/tools/wise.py vm4 restart
simtime=$(date +%s)

for i in $seed; do

	seed_hash=`basename $i`
	echo $i $seed_hash
	if [ -f $seed_dir/tmin_collision/$seed_hash ]; then
		continue
	fi
	python3 $AUTOWARE_FUZZER/tmin/LF2WP.py -i $i -o $seed_dir/wp_collision/$seed_hash 
    
	python3 $AUTOWARE_FUZZER/tools/wise.py vm4 restart
	python3 $AUTOWARE_FUZZER/tmin/tmin.py -i $seed_dir/wp_collision/$seed_hash -o $seed_dir/tmin_collision/$seed_hash --type npc --strategy bisection_limit
	
	python3 $AUTOWARE_FUZZER/tools/wise.py vm4 restart
	python3 $AUTOWARE_FUZZER/tmin/save_obj.py $seed_dir/tmin_collision/$seed_hash $seed_dir/collision_data
done
