#!/bin/bash

dir=$PWD
# dirlist=`ls -d */`
dirlist=`cat $1`
# blacklist=(RUS_Bicycle-1_1_T-1 DEU_Muc-4_1_T-1 DEU_Lohmar-32_1_I-1-1 ESP_Mad-2_1_T-1 USA_US101-7_5_T-1 DEU_Flensburg-6_1_T-1 DEU_Flensburg-61_1_T-1 USA_Lanker-1_11_I-1-1 USA_US101-23_1_T-1 DEU_Lohmar-20_1_T-1 DEU_Flensburg-54_1_T-1)
# target=(ZAM_ACC-1_1_I-1-1)
target=(DEU_Muc-23_2_T-1)


function stop_bridge(){
	pids=`ps -ef | grep bridge | awk '{print $2}'`
	for pid in $pids
	do
        kill -9 $pid
	done
}

function clean_autoware(){
    pids=`ps -ef | grep autoware.ai.openplanner | awk '{print $2}'`
    # echo $pids
	for pid in $pids
	do
        kill -9 $pid
	done
}

function getMap()
{
	python3 - "$@" <<END
#!/usr/bin/python3
import json
import sys
with open(sys.argv[1]) as f:
	data = json.load(f)
print(data["map"]["name"])
END
}

for scenario in $dirlist
do
	seed_dir=$dir/$scenario
	echo $seed_dir

	# [[ ${blacklist[@]/${scenario:0:-1}/} != ${blacklist[@]} ]] && continue
	# [[ ${target[@]/${scenario:0:-1}/} == ${target[@]} ]] && continue

	# killall -9 $HOME/svlsimulator-linux64-2021.2.2/simulator >& /dev/null
	killall -9 $HOME/Build_Local/simulator >& /dev/null
	# DISPLAY=:0 ~/svlsimulator-linux64-2021.2.2/simulator &
	rosnode kill -a
	clean_autoware
	pkill -P $$ --signal 9
	stop_bridge
	killall -9 rosmaster
	sleep 3
	roscore &
	
	if [ -f $seed_dir/fuzzer.log ]; then
		continue
	fi
	
	cd $seed_dir
	rm -rf $seed_dir/out/*
	echo "Wait 5 second to run fuzzing on "$scenario
	sleep 5

	start=$(date +%s)

	# timeout --foreground 150 python3 ~/apollo-fuzzer/fuzzer.py --corpus $seed_dir/corpus --lane $seed_dir/lane/*.xodr --out $seed_dir/*_out/
	python3 $AUTOWARE_FUZZER/fuzzer.py --corpus $seed_dir/corpus --lane $seed_dir/lane/*.xodr --out $seed_dir/out/

	end=$(date +%s)
	take=$(( end - start ))
	echo Time taken to execute commands is ${take} seconds.
done

