import rospy
import roslaunch
import xml.etree.ElementTree as ET
import os
import re
OPENDRIVE_DIR = '/opt/carla-simulator/PythonAPI/util/opendrive/carla_seeds/'
OSM_DIR = '/home/autoware/autoware_fuzzing/commonroad_osm/'
OUTPUT_DIR = '/home/autoware/autoware_fuzzing/csv/'
ODR_OUTPUT_DIR = '/home/autoware/autoware_fuzzing/opendrive/'
def extract_origin(opendrive_path):
    tree = ET.parse(opendrive_path)
    root = tree.getroot()
    geoReference = root.find('header').find('geoReference')
    sep = re.split("[= ]",geoReference.text)
    lat_0 = '0'
    lon_0 = '0'
    for i in range(len(sep)):
        if sep[i] == '+lat_0':
            lat_0 = sep[i+1]
        if sep[i] == '+lon_0':
            lon_0 = sep[i+1]
    return (lat_0,lon_0)

osm_list = open('/home/autoware/autoware_fuzzing/commonroad_osm/list.txt','r').readlines()
odr_list = []

for osm in osm_list:
    for file in os.listdir(OPENDRIVE_DIR + osm.strip('\n')):
        if file.startswith("FIX-"):
            opendrive_path = OPENDRIVE_DIR + osm.strip('\n') + '/' + file
            odr_list.append(opendrive_path)
            '''
            lat,lon = extract_origin(opendrive_path)
            cmd =  'rosrun lanelet_aisan_converter lanelet2aisan '
            cmd += '_map_file:={} '.format(OSM_DIR + osm.strip('\n') + '.osm')
            cmd += '_origin_lat:={} _origin_lon:={} '.format(lat,lon)
            cmd += '_save_dir:={}'.format(OUTPUT_DIR+osm.strip('\n'))
            os.system(cmd)
            '''
            cmd = 'cp {} {}.xodr'.format(opendrive_path,ODR_OUTPUT_DIR+osm.strip('\n'))
            os.system(cmd)