import sys
import os
import xml.etree.ElementTree as ET
import re

def extract_origin(opendrive_path):
    tree = ET.parse(opendrive_path)
    root = tree.getroot()
    geoReference = root.find('header').find('geoReference')
    sep = re.split("[= ]",geoReference.text)
    lat_0 = '0'
    lon_0 = '0'
    for i in range(len(sep)):
        if sep[i] == '+lat_0':
            lat_0 = sep[i+1]
        if sep[i] == '+lon_0':
            lon_0 = sep[i+1]
    return (lat_0,lon_0)

def osm2csv(osmpath, odrpath, outpath):
    lat,lon = extract_origin(odrpath)
    cmd =  'rosrun lanelet_aisan_converter lanelet2aisan '
    cmd += '_map_file:={} '.format(osmpath)
    cmd += '_origin_lat:={} _origin_lon:={} '.format(lat,lon)
    cmd += '_save_dir:={}'.format(outpath)
    os.system(cmd)

def main():
    osmpath = sys.argv[1]
    odrpath = sys.argv[2]
    outpath = sys.argv[3]
    osm2csv(osmpath,odrpath,outpath)

if __name__=='__main__':
    main()