#!/usr/bin/zsh
pyosm2csv=$AUTOWARE_FUZZER/map_convert/osm2csv.py
pycrxml2osm=$AUTOWARE_FUZZER/map_convert/cmrxml2osm.py

if [ $CONDA_DEFAULT_ENV != "commonroad" ];then
    conda activate commonroad
fi

while getopts "i:o:x:" opt
do
    case $opt in 
        i)
            input=$OPTARG
            ;;
        o)
            output=$OPTARG
            ;;
        x)
            xodr=$OPTARG
            ;;
    esac
done

python $pycrxml2osm $input /tmp/`basename $input`.osm
mkdir -p $output
python $pyosm2csv /tmp/`basename $input`.osm $xodr $output 