import sys
import os
del sys.path[-1]
sys.path.append('/xxxxx/commonroad-scenario-designer/commonroad-scenario-designer')
from lxml import etree
from commonroad.common.file_reader import CommonRoadFileReader
from crdesigner.map_conversion.lanelet_lanelet2.cr2lanelet import CR2LaneletConverter
import xml.etree.ElementTree as ET

def commonroad2lanelet(input_path = "USA_Lanker-1_1_T-1.xml", output_name = "USA_Lanker_1.osm", proj = ""):
    # ----------------------------------------------- Option 1: General API ------------------------------------------------
    # load CommonRoad file and convert it to lanelet format
    #commonroad_to_lanelet(input_path, output_name, proj)

    # ---------------------------------------- Option 2: Lanelet conversion APIs -------------------------------------------
    try:
        commonroad_reader = CommonRoadFileReader(input_path)
        scenario, _ = commonroad_reader.open()
    except etree.XMLSyntaxError as xml_error:
        print(f"SyntaxError: {xml_error}")
        print(
            "There was an error during the loading of the selected CommonRoad file.\n"
        )
        scenario = None

    if scenario:
        l2osm = CR2LaneletConverter(proj)
        osm = l2osm(scenario)
        with open(f"{output_name}", "wb") as file_out:
            file_out.write(
                etree.tostring(
                    osm, xml_declaration=True, encoding="UTF-8", pretty_print=True
                )
            )

if __name__ == '__main__':
    input_xml_path = sys.argv[1]
    output_path = sys.argv[2]
    commonroad2lanelet(input_xml_path,output_path)