scenario_list=`cat $1`
scenarios_dir=$HOME/src/repos/DONE2
cmrxml_dir=$HOME/src/repos/commonroad-scenarios
pyosm2csv=$AUTOWARE_FUZZER/map_convert/osm2csv.py
pycrxml2osm=$AUTOWARE_FUZZER/map_convert/cmrxml2osm.py

function getMap()
{
	python3 - "$@" <<END
#!/usr/bin/python3
import json
import sys
with open(sys.argv[1]) as f:
	data = json.load(f)
print(data["map"]["name"])
END
}

if [ -d /tmp/osm ]; then
    rm -r /tmp/osm
fi
mkdir /tmp/osm

for scenario_name in $scenario_list
do
    mapname=`getMap $scenarios_dir/$scenario_name/$scenario_name.json`
    if [ ! -n "$mapname" ]; then
        continue
    fi
    echo $mapname
    crxml=`find $cmrxml_dir -name $scenario_name.xml`
    if [ ! -n "$crxml" ]; then
        # echo $scenario_name" not exist"
        crxml=`find $cmrxml_dir -name $scenario_name.cr.xml`
    fi
    if [ ! -n "$crxml" ]; then
        echo $scenario_name" not exist"
        # crxml=`find $cmrxml_dir -name $scenario_name.cr.xml`
    fi
    for xml in $crxml
    do
        if [ -f $xml ]; then
            echo $xml
            python $pycrxml2osm $xml /tmp/osm/$scenario_name.osm

            if [ -d ~/shared_dir/autoware-data/$mapname ];then
                rm -r ~/shared_dir/autoware-data/$mapname
            fi
            mkdir ~/shared_dir/autoware-data/$mapname
            python $pyosm2csv /tmp/osm/$scenario_name.osm $scenarios_dir/$scenario_name/lane/*.xodr ~/shared_dir/autoware-data/$mapname
        fi
        break
    done
    # echo $xml" exist"
done