#!/bin/bash

export DIR=$HOME/apollo-fuzzer/tools
export SVLSIM__ACCESS_TOKEN="dc18aef7ed28946e0d3138d966feb20b7f6d8619d6de5afb671691741aa6f0e7"


logfile="$DIR/run.log"

# simulation_id="e931bfc6-5ef5-4903-ad19-b159f2a53d8e" # manual control
simulation_id="f51a8129-cf7e-4346-9972-81c489e61d80" # API Only


# Initialize a CLI session.  A successful "cli initialize" outputs nothing.
while true; do
	if result=$(sh $DIR/svlsim.sh cli initialize 2>${logfile}); then
	    : SUCCESS
	    break
	else
	    # One error will be that svlsim.sh is out-of-date and needs to be re-downloaded.
	    echo "ABORT: ${result}"
	    exit 1
	fi
done

while true; do
    if result=$(sh $DIR/svlsim.sh simulation stop ${simulation_id} 2>>${logfile}); then
        : SUCCESS
        break
    else
        echo "ERROR: ${result}"

        if [[ $result =~ .*running.* ]]; then
            break
        else
            sleep 2
        fi

    fi
done

# sleep 5

# while true; do
#     if result=$(sh $DIR/svlsim.sh simulation start ${simulation_id} 2>>${logfile}); then
#         : SUCCESS
#         break
#     else
#         echo "ERROR: ${result}"

#         if [[ $result =~ .*already.* ]]; then
#             break
#         else
#             sleep 2
#         fi

#     fi
# done

while true; do
    sleep 2
    if status=$(sh svlsim.sh simulation check ${simulation_id} 2>>${logfile}); then
        if [ ${status} == "progressing" ]; then
            break
        fi
    fi
    if result=$(sh $DIR/svlsim.sh simulation start ${simulation_id} 2>>${logfile}); then
        : SUCCESS
        break
    else
        echo "ERROR: ${result}"
    fi
done
