# Code Style Guide

This project follows consistent Python coding conventions to ensure readability and maintainability.

---

#### General Guidelines

- Use **Python 3.9+**
- All Python code is developed using the `black` formatter
- Always include the shebang at the top of executable scripts: `#!/usr/bin/env python3`
- Imports must be sorted automatically using `isort`
- Documentation using DOCSTRINGS in `Google Format`

#### Naming Conventions 

- Function and Variables: `snake_case`
- Classes: `PascalCase`
- Constants: `UPPER_SNAKE_CASE`