import matplotlib.pyplot as plt
import numpy as np


def as_incompat(quant: list[float], spm_bound: list[float]) -> list[float]:
    return [q / spm - 1 for q, spm in zip(quant, spm_bound)]


if __name__ == "__main__":
    data = np.load("figure2.npz", allow_pickle=False)
    copies = data["copies"]
    prior_losses = data["prior_losses"]
    spm_bound = data["spm_bound"]
    rpm_bound = data["rpm_bound"]
    nhb_bound = data["nhb_bound"]
    pgm_bound = data["pgm_bound"]
    tom_bound = data["tom_bound"]

    # rpm_incompat = as_incompat(rpm_bound, spm_bound)
    nhb_incompat = as_incompat(nhb_bound, spm_bound)
    pgm_incompat = as_incompat(pgm_bound, spm_bound)
    tom_incompat = as_incompat(tom_bound, spm_bound)
    prior_incompt = as_incompat(prior_losses, spm_bound)

plt.rcParams.update(
    {
        "text.usetex": True,
        "font.family": "Helvetica",
    }
)

f, a = plt.subplots(figsize=(6, 4), constrained_layout=True)
size_value = 16
width_value = 2.2

grid_ls = ":"
grid_color = "grey"

for yline in [0, 1]:
    a.plot(
        [np.min(copies), np.max(copies)],
        [yline, yline],
        linestyle=grid_ls,
        color=grid_color,
        linewidth=0.85 * width_value,
        zorder=0,
    )

a.plot(
    copies,
    prior_incompt,
    "-x",
    linewidth=width_value,
    color="black",
    markersize=5,
    markeredgewidth=width_value,
)

a.plot(
    copies,
    pgm_incompat,
    "-o",
    linewidth=width_value,
    color="black",
    markersize=4,
    markeredgewidth=width_value,
)

a.plot(
    copies,
    nhb_incompat,
    "-^",
    linewidth=width_value,
    color="black",
    markersize=3,
    markeredgewidth=width_value,
)

a.plot(
    copies,
    tom_incompat,
    "-v",
    linewidth=width_value,
    color="black",
    markersize=3,
    markeredgewidth=width_value,
)

a.fill_between(
    copies,
    nhb_incompat,
    tom_incompat,
    color="grey",
    alpha=0.3,
    zorder=0,
)


a.set_xlabel(r"$n$", fontsize=size_value)
a.set_ylabel(r"$\mathcal{I}$", fontsize=size_value)
a.tick_params(axis="both", which="both", labelsize=size_value)
a.xaxis.set_major_locator(plt.MultipleLocator(1))

ax_inset = f.add_axes([0.43, 0.57, 0.29, 0.28])
ax_inset.plot(
    copies,
    spm_bound,
    "-",
    linewidth=0.75 * width_value,
    color="black",
)

ax_inset.set_xlabel(r"$n$", fontsize=0.9 * size_value)
ax_inset.set_ylabel(r"$\mathcal{L}_{\mathrm{SPM}}$", fontsize=0.9 * size_value)
ax_inset.tick_params(axis="both", which="both", labelsize=0.9 * size_value)
ax_inset.xaxis.set_major_locator(plt.MultipleLocator(1))

f.savefig("fig2.pdf", format="pdf", bbox_inches="tight")
