import numpy as np
import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator
from mpl_toolkits.axes_grid1.inset_locator import mark_inset

results = np.load("figure1.npz")

incomp_nh_vals = results["incomp_nh"]
incomp_pgm_vals = results["incomp_pgm"]
loss_spm_vals = results["loss_spm"]
incomp_prior_vals = results["incomp_prior"]
incomp_pgm_star_vals = results["incomp_pgm_star"]

d_values = np.arange(2, len(incomp_nh_vals) + 2)

plt.rcParams.update(
    {
        "text.usetex": True,
        "font.family": "Helvetica",
    }
)

fig, ax = plt.subplots(figsize=(6, 4), constrained_layout=True)
size_value = 16
width_value = 2.2

ax.plot(
    d_values,
    incomp_prior_vals,
    ":",
    linewidth=width_value,
    color="black",
)
ax.plot(
    d_values,
    incomp_pgm_star_vals,
    "-.",
    linewidth=width_value,
    color="black",
)
ax.plot(
    d_values,
    incomp_nh_vals,
    "-",
    linewidth=width_value,
    color="black",
)
ax.plot(
    d_values,
    incomp_pgm_vals,
    "--",
    linewidth=width_value,
    color="black",
)

ax.set_xlabel(r"$d$", fontsize=size_value)
ax.set_ylabel(r"$\mathcal{I}$", fontsize=size_value)
ax.tick_params(axis="both", which="both", labelsize=size_value)
ax.xaxis.set_major_locator(MultipleLocator(2))

ax.fill_between(
    d_values,
    incomp_nh_vals,
    incomp_pgm_star_vals,
    color="lightgrey",
    alpha=1,
    zorder=0,
)

ax_inset1 = fig.add_axes([0.27, 0.57, 0.25, 0.25])
ax_inset1.plot(
    d_values,
    loss_spm_vals,
    "-",
    linewidth=0.75 * width_value,
    color="black",
)

ax_inset1.set_xlabel(r"$d$", fontsize=0.9 * size_value)
ax_inset1.set_ylabel(r"$n^2 \mathcal{L}_{\mathrm{SPM}} $", fontsize=0.9 * size_value)
ax_inset1.tick_params(axis="both", which="both", labelsize=0.9 * size_value)
ax_inset1.xaxis.set_major_locator(MultipleLocator(3))
ax_inset1.set_yticks([2.50, 2.75, 3.00])

ax_inset2 = fig.add_axes([0.65, 0.57, 0.25, 0.25])

ax_inset2.plot(
    d_values,
    incomp_prior_vals,
    ":",
    linewidth=0.75 * width_value,
    color="black",
)
ax_inset2.plot(
    d_values,
    incomp_pgm_star_vals,
    "-.",
    linewidth=0.75 * width_value,
    color="black",
)
ax_inset2.plot(
    d_values,
    incomp_nh_vals,
    "-",
    linewidth=0.75 * width_value,
    color="black",
)

ax_inset2.set_xlim(12, 15)
ax_inset2.set_ylim(np.min(incomp_pgm_star_vals[-3:]) * 0.8, np.max(incomp_prior_vals[-3:]) * 1.4)

ax_inset2.set_xlabel(r"$d$", fontsize=0.9 * size_value)
ax_inset2.set_ylabel(r"$\mathcal{I}$", fontsize=0.9 * size_value)
ax_inset2.tick_params(axis="both", which="both", labelsize=0.9 * size_value)
ax_inset2.set_xticks([13, 14])
ax_inset2.yaxis.set_major_locator(MultipleLocator(0.01))

ax_inset2.fill_between(
    d_values,
    incomp_nh_vals,
    incomp_pgm_star_vals,
    color="lightgrey",
    alpha=1,
    zorder=0,
)

mark_inset(
    ax,
    ax_inset2,
    loc1=3,
    loc2=4,
    fc="none",
    ec="0.6",
    lw=1.2,
    linestyle=":",
)

plt.savefig("fig1.pdf", format="pdf", bbox_inches="tight")
