# Shepherd Dynamics: Computational Frameworks for Conflict Prediction

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.17766946.svg)](https://doi.org/10.5281/zenodo.17766946)
[![License: CC BY 4.0](https://img.shields.io/badge/License-CC%20BY%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by/4.0/)

## Overview

This repository contains two interconnected research frameworks for understanding and predicting conflict dynamics:

### Paper I: Nucleation Detection
**Variance inflection as an early warning signal for phase transitions**
- F1 Score: 0.77
- 100% accuracy on commitment-type transitions
- Detects both classical (CSD) and commitment (calm before storm) dynamics

### Paper II: Compression Dynamics
**KL-divergence of actor worldviews as a conflict predictor**
- Correlation: r = 0.33, p < 0.05
- Temporal precedence: divergence leads conflict (r = 0.67)
- Correctly identifies geopolitical alignments

## Key Insight

> *"Conflict is compression divergence. Transitions are variance inflection. Peace is alignment."*

## Contents

```
zenodo-package/
├── SHEPHERD_DYNAMICS_COMPENDIUM.md    # Full research compendium
├── README.md                          # This file
├── LICENSE                            # CC BY 4.0
├── .zenodo.json                       # Zenodo metadata
├── figures/                           # All publication figures
│   ├── fig1_variance_reduction.png    # Nucleation: variance dynamics
│   ├── fig2_*_example.png             # Nucleation: transition examples
│   ├── fig3_detector_comparison.png   # Nucleation: detector performance
│   ├── fig1_framework.png             # Compression: theoretical framework
│   ├── fig2_divergence_heatmap.png    # Compression: actor divergence
│   ├── fig3_correlation.png           # Compression: validation
│   └── fig4_roc.png                   # Compression: prediction ROC
├── code/                              # Source code (see main repo)
└── data/                              # Validation results
```

## Quick Results

### Nucleation Detection

| Transition Type | F1 Score |
|-----------------|----------|
| Transcritical   | 0.889    |
| Nucleation      | 0.883    |
| Commitment      | 0.864    |
| Saddle-node     | 0.830    |
| Pitchfork       | 0.788    |
| Hopf            | 0.347    |

### Compression Dynamics

| Hypothesis | Result | Value |
|------------|--------|-------|
| H1: Divergence correlates with conflict | ✓ PASS | r=0.33, p<0.05 |
| H2: Divergence leads conflict | ✓ PASS | r=0.67 (lagged) |
| H3: Predicts escalation | Partial | AUC=0.59 |

## Usage

```bash
# Clone the full repository
git clone https://github.com/aphoticshaman/orthogonal.git
cd orthogonal

# Run nucleation experiments
cd nucleation-paper
pip install -r requirements.txt
python run_experiments.py

# Run compression experiments
cd ../compression-conflict-paper
pip install -r requirements.txt
python run_validation.py
```

## Citation

```bibtex
@software{cardwell2025shepherd,
  author       = {Cardwell, Ryan J.},
  title        = {Shepherd Dynamics: Computational Frameworks for Conflict Prediction},
  month        = nov,
  year         = 2025,
  publisher    = {Zenodo},
  doi          = {10.5281/zenodo.XXXXXXX},
  url          = {https://doi.org/10.5281/zenodo.17766946}
}
```

## License

This work is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/).

## Author

**Ryan J Cardwell (Archer Phoenix)**
- Independent Researcher
- Shepherd Dynamics Project

## Acknowledgments

Built with assistance from Claude (Anthropic).
