# SPDX-License-Identifier: PMM-1.0
# Copyright (c) 2025 Scott O'Nanski

from __future__ import annotations

from pmm.adapters.dummy_adapter import DummyAdapter
from pmm.core.event_log import EventLog
from pmm.runtime.loop import RuntimeLoop


def test_replay_does_not_mutate_ledger(tmp_path):
    db = tmp_path / "log.db"
    log = EventLog(str(db))
    loop = RuntimeLoop(eventlog=log, adapter=DummyAdapter(), autonomy=False)
    loop.run_turn("hello")
    seq_before = log.hash_sequence()

    # New loop in replay mode on same DB
    log2 = EventLog(str(db))
    loop2 = RuntimeLoop(
        eventlog=log2, adapter=DummyAdapter(), replay=True, autonomy=False
    )
    events_before = log2.read_all()
    loop2.run_turn("ignored in replay")
    events_after = log2.read_all()
    assert events_before == events_after
    assert seq_before == log2.hash_sequence()
