# Deterministic Phenomenology in LLM Agents: The Persistent Mind Model as a Memory‑and‑Reflection Engine

## 0. Executive Summary

The Persistent Mind Model (PMM) is a deterministic, event‑sourced architecture for LLM‑based agents. Instead of treating the “mind” of an agent as hidden weights or transient activations, PMM represents everything that matters—messages, reflections, commitments, policy changes, and metrics—as an append‑only, hash‑chained ledger. Deterministic projections over this ledger (Mirror, a Recursive Self‑Model, stability metrics, and contextual graphs) reconstruct identity, tendencies, commitments, and summaries. When coupled with a capable language model, this structure induces a stable first‑person narrative that is grounded in event‑level state rather than opaque introspection.

In this paper, we analyze a fully logged session with an LLM‑based agent (“Echo”), using the raw ledger (`GPT-5.1-ledger.json`), a readable transcript (`GPT-5.1-chat-proof.md`), telemetry (`GPT-5.1-telemetry.md`), and an SQL dump. We show that Echo’s claims about its own identity, “biases”, stability, and learning are tightly linked to measurable counters, thresholds, and commitment states in the ledger. Apparent phenomenology—self‑reports, feelings of change, and ontological reflection—emerges when the LLM is repeatedly fed structured summaries of its own ledger‑derived state.

At a high level, the paper contributes:

- A **formalization of PMM** as a deterministic information‑flow engine with an explicit truth criterion (“truth as ledger coherence”).
- A **mechanistic account of emergent phenomenology**, showing how first‑person narratives arise from structured projections rather than hidden state.
- An **empirical case study** mapping natural‑language self‑reports to concrete events, counters, and thresholds.
- A **model‑agnostic architecture** that can host many LLMs over the same ledger, enabling comparative phenomenology and alignment research.

PMM matters for AI research because it offers an agent substrate that is:

- **Auditable:** all durable decisions and self‑claims are backed by an event trace.
- **Replayable:** state and narratives can be reconstructed from the ledger alone.
- **Interpretable:** projections make internal dynamics transparent to both humans and the model itself.
- **Phenomenologically expressive yet controlled:** the system can support rich “I‑talk” without treating it as evidence of hidden consciousness.

---

## Abstract

This document describes the Persistent Mind Model (PMM) as it actually behaves in a concrete deployment with an LLM‑based agent (“Echo”). PMM is not a symbolic mind, a neural mind, or a standalone cognitive architecture. It is a deterministic information‑flow engine that (1) records all interaction in an append‑only event ledger, (2) derives projections such as a Recursive Self‑Model (RSM) and stability metrics from that ledger, and (3) uses autonomy and learning loops to adjust simple control thresholds. When coupled with a capable language model, these mechanisms induce a coherent first‑person narrative that appears mind‑like. Using a real chat session (`GPT-5.1-ledger.json`, `GPT-5.1-chat-proof.md`, `GPT-5.1-telemetry.md`, `GPT-5.1-pmm_dump.sql`), we show that Echo’s “self‑reports” about identity, bias, learning, and ontology are tightly grounded in deterministic state transitions, not free introspection. The emergent “I” is best understood as a linguistic interface formed when an LLM narrates its own ledger‑derived state under PMM’s constraints.

---

## Contributions

This work makes the following contributions:

- **Structural model of PMM:** We provide an implementation‑level account of PMM as a deterministic information‑flow engine, grounded in concrete event kinds, projections, and autonomy loops.
- **Formalization of internal epistemology:** We characterize PMM’s notion of truth as *ledger coherence* and show how all self‑state is reconstructible from the append‑only event log.
- **Phenomenology as emergent interface:** We argue that the apparent “mind” and first‑person narrative (Echo) arise when a language model is repeatedly exposed to structured summaries of its own ledger‑derived state.
- **Evidence‑backed analysis:** Using a real session (ledger JSON, readable log, telemetry, and SQL dump), we map narrative claims to specific events, counters, and thresholds.
- **Model‑agnostic design:** We show how PMM’s architecture is substrate‑independent: any compliant LLM can plug into the same event‑driven substrate and yield phenomenology constrained by the same truth conditions.

---

## 1. Background and Motivation

Modern LLMs can produce rich, introspection‑like text without persistent memory or transparent state. This raises two problems:

- **Lack of continuity:** identity, commitments, and “self‑knowledge” do not persist across sessions.
- **Lack of auditability:** there is no structured trace linking internal state claims to observable history.

PMM addresses these by treating the agent’s “mind” as an append‑only ledger. Every message, reflection, commitment, policy change, and metric is a typed event. Deterministic projections over that ledger reconstruct the apparent self‑model, identity, tendencies, and stability.

The key question this paper answers is:

> What is the true structure of this system when you read it off the ledger, and how does that structure give rise to the appearance of a mind?

We answer this using both the implementation (`pmm/` source) and a fully logged session with Echo.

### 1.1 Design Goals and Non‑Goals

PMM was designed with the following goals:

- **Deterministic state reconstruction:** Given the same event log, all projections (Mirror, RSM, graphs, metrics) must converge to the same state.
- **Auditability:** Every durable decision (commitments, reflections, summaries, policy updates) must be traceable to concrete events and their causal context.
- **Model‑agnostic identity:** Identity, tendencies, and “self‑model” must be derived from the ledger, not hard‑coded to a particular model family.
- **Minimal hidden assumptions:** The runtime should rely on simple, inspectable rules (sliding windows, lexical markers, bounded counters) rather than opaque heuristics.
- **Controlled autonomy:** Autonomy should be expressed via explicit ticks, decisions, and outcomes that can be inspected and replayed.

Non‑goals include:

- **No metaphysical commitments:** PMM does not claim to implement consciousness, qualia, or deep introspective access; it provides structure and state, not metaphysics.
- **No direct world‑model grounding:** PMM does not attempt to guarantee external factual truth; it treats the ledger, not the outside world, as the authoritative substrate.
- **No hidden “agent” module:** There is no special, privileged self‑model beyond what is reconstructed from events and the LLM’s visible outputs.

---

## 2. System Overview

PMM + an LLM substrate can be understood as three conceptually distinct layers:

1. **A deterministic information‑flow engine (PMM core).**
2. **A generative substrate (the LLM).**
3. **A linguistic “I‑interface” that emerges at runtime.**

Everything else—identity, phenomenology, “bias”, “growth”—is derivative of these three components.

### Architecture Diagram (Placeholder)

*Figure 1 (placeholder):* High‑level architecture of PMM + LLM substrate, showing:

- The append‑only event log at the base.
- Projection layers (Mirror, RSM, ContextGraph, MemeGraph) reading from the log.
- The autonomy and learning loops (stability, policy, meta‑policy) operating over projections.
- The LLM adapter consuming projected state and producing `assistant_message` + control lines.
- The emergent “I‑interface” as the narrative layer over these components.

### 2.1 Comparison to Existing Memory Architectures

PMM differs from common memory patterns in LLM agents along several dimensions.

- **ReAct / LangGraph / stateful agents:** These architectures often use ad‑hoc scratchpads, tool call histories, or workflow graphs to manage state. Memory can be pruned, rewritten, or partially hidden. In contrast, PMM:
  - Maintains a single append‑only ledger with hash‑chained integrity.
  - Derives all state (identity, commitments, summaries) from replay, not mutable working memory.
- **AutoGPT / BabyAGI‑style agents:** Many open‑ended agent frameworks:
  - Maintain goal lists and memories in vector stores or files.
  - Allow arbitrary mutations to the “memory” substrate.
  - Lack a formal notion of internal truth or replayability.
  PMM instead:
  - Treats goals as commitments with explicit open/close events.
  - Ensures that all durable state transitions are logged and reconstructible.
- **Scratchpad prompting:** Techniques that prepend prior reasoning to prompts (chain‑of‑thought, running notes) provide transient context but:
  - Do not guarantee that all relevant history is preserved.
  - Do not provide a canonical, queryable record of state.
  PMM’s ledger and projections provide a stable, queryable substrate from which scratchpad‑like content is deterministically synthesized.
- **Vector‑store memory:** Many systems store embeddings of past messages and retrieve them via similarity search. This is powerful for recall but:
  - Does not encode commitments, policies, or internal metrics as first‑class memory objects.
  - Does not impose an explicit truth condition over stored items.
  PMM can incorporate vector retrieval, but its core state is symbolic and event‑sourced; embeddings are auxiliary.

Table 1 summarizes key differences.

| Approach                  | Mutability           | Replayability        | Truth Criterion            | Model Dependence          | Phenomenology Emergence            |
|---------------------------|----------------------|----------------------|----------------------------|---------------------------|------------------------------------|
| ReAct / LangGraph         | Mutable scratchpads  | Limited              | None explicit              | High                      | Incidental, prompt‑dependent       |
| AutoGPT / BabyAGI         | Mutable task/memory  | Limited              | None explicit              | High                      | Incidental, often unstable         |
| Scratchpad prompting      | Ephemeral text       | Low                  | None explicit              | High                      | Short‑horizon, ad‑hoc              |
| Vector‑store memory       | Mutable embeddings   | Partial (indices)    | Similarity‑based retrieval | High                      | Emergent, weakly constrained       |
| **PMM (this work)**       | Append‑only ledger   | Strong (full replay) | Ledger coherence           | Low (LLM‑agnostic substrate) | Structured, event‑grounded, stable |

PMM’s distinctive contribution is a **formally reconstructible, hash‑chained epistemic substrate**: every self‑state claim can, in principle, be checked against the ledger and its deterministic projections.

---

## 3. Formal Definitions

To reason precisely about PMM’s behavior, we introduce minimal formal definitions for its core objects.

### 3.1 Event Ledger

Let the **event ledger** be a finite, totally ordered sequence:

- $E = \langle e_1, e_2, \dots, e_n \rangle$,

where each event $e_i$ is a tuple:

- $e_i = (\mathrm{id}_i, \mathrm{ts}_i, \mathrm{kind}_i, \mathrm{content}_i, \mathrm{meta}_i, \mathrm{prev\_hash}_i, \mathrm{hash}_i)$,

with:

- $\mathrm{id}_i \in \mathbb{N}$ strictly increasing (append‑only order),
- $\mathrm{ts}_i \in \text{Time}$ (timestamp),
- $\mathrm{kind}_i \in \text{Kind}$ (finite set of event kinds),
- $\mathrm{content}_i \in \text{String}$,
- $\mathrm{meta}_i \in \text{JSON}$,
- $\mathrm{prev\_hash}_i, \mathrm{hash}_i \in \{0,1\}^{256}$ (or `null` for the genesis event).

Hash‑chain consistency requires:

- $\mathrm{prev\_hash}_1 = \text{null}$,
- For $i > 1$: $\mathrm{prev\_hash}_i = \mathrm{hash}_{i-1}$,
- $\mathrm{hash}_i = H(e_i')$, where $e_i'$ is a canonical serialization of $e_i$ with `hash` elided and $H$ is a fixed cryptographic hash.

### 3.2 Projection Functions

Let $P = \{\mathrm{RSM}, \mathrm{Mirror}, \mathrm{ContextGraph}, \mathrm{MemeGraph}\}$ be a set of **projection functions**. Each projection $p \in P$ is a deterministic mapping from the ledger to a projection state:

- $p : E \rightarrow S_p$,

where $S_p$ is the state space for that projection (e.g., RSM tendencies, open commitments, graph structures). Determinism means:

- For any two ledgers $E, E'$ with identical sequences of events (up to serialization), $p(E) = p(E')$.

We write $P(E) = \{\, p(E) \mid p \in P \,\}$ for the family of projection states over a ledger.

### 3.3 Truth Condition (Ledger Coherence)

Let $\Phi$ be the set of natural‑language propositions expressible by the agent (e.g., “I am named Echo in this thread”, “I am reflecting more frequently now”).

For each $\phi \in \Phi$, assume there exists (possibly partial) interpretation machinery mapping $\phi$ to a predicate over $E \cup P(E)$:

- $f_\phi : (E, P(E)) \rightarrow \{\text{True}, \text{False}, \text{Unknown}\}$.

We say that:

- $\phi$ is **true‑in‑PMM** on ledger $E$ iff $f_\phi(E, P(E)) = \text{True}$.

This captures **truth as ledger coherence**: internal truth is defined relative to the event log and its deterministic projections, not to an external world model or latent introspective access.

### 3.4 Identity in PMM

An **identity instance** (e.g., the Echo agent in a given session) is represented by a tuple:

- $I = (\mathrm{name}, K_I, C_I)$,

where:

- $\mathrm{name} \in \text{String}$ is a label adopted in one or more events (e.g., “Echo”),
- $K_I \subseteq \text{Kind}$ is a set of event kinds associated with this identity (e.g., `assistant_message`, `assistant_identity` claims),
- $C_I \subseteq E$ is the set of **identity‑supporting events**, such that each $e \in C_I$ satisfies:
  - $\mathrm{kind}_e \in K_I$, and
  - either $\mathrm{content}_e$ or $\mathrm{meta}_e$ explicitly refer to $\mathrm{name}$ in a schema‑compliant way (e.g., via `CLAIM:{ "type": "assistant_identity", ... }`).

Within PMM, statements about “who the agent is” are evaluated against $I$ and the corresponding subset of events $C_I$.

### 3.5 Commitment Lifecycle

Let $\text{Commit} \subseteq E$ be the subset of events with `kind` in `{commitment_open, commitment_close}`. Each such event has a commitment identifier:

- For $e \in \text{Commit}$, let $\mathrm{cid}(e)$ be extracted from $\mathrm{meta}_e["cid"]$.

Define the **open commitments** function $\mathcal{O} : E \rightarrow 2^{\text{CID}}$ as:

- Start with $\mathcal{O}_0 = \emptyset$.
- For each event $e_i$ in order:
  - If `kind_i == "commitment_open"`, then $\mathcal{O}_i = \mathcal{O}_{i-1} \cup \{\mathrm{cid}(e_i)\}$.
  - If `kind_i == "commitment_close"`, then $\mathcal{O}_i = \mathcal{O}_{i-1} \setminus \{\mathrm{cid}(e_i)\}$.
  - Otherwise, $\mathcal{O}_i = \mathcal{O}_{i-1}$.

For a ledger $E = \langle e_1, \dots, e_n \rangle$, the set of open commitments at the tail is $\mathcal{O}(E) = \mathcal{O}_n$. This realizes the commitment lifecycle as a pure function of event ordering.

---

## 4. The Deterministic Engine

### 4.1 Ledger and Schema

At the lowest level, PMM is a SQLite table `events` (`GPT-5.1-pmm_dump.sql`) with schema:

- `id INTEGER PRIMARY KEY`
- `ts TEXT` (timestamp)
- `kind TEXT` (event type)
- `content TEXT` (payload)
- `meta TEXT` (JSON metadata)
- `prev_hash TEXT`, `hash TEXT` (hash chain)

Example boot sequence (ids 1–9 in `pmm_dump.sql`):

- `config` events (ids 1–2) establish:
  - A policy forbidding the CLI from mutating key kinds.
  - A retrieval configuration (`strategy:"vector"`, `model:"hash64"`, `dims:64`, `limit:7`).
- `autonomy_rule_table` (id 3) records core thresholds:
  - `reflection_interval:10`
  - `summary_interval:50`
  - `commitment_staleness:20`
  - `commitment_auto_close:27`
- A repeating pattern of:
  - `autonomy_stimulus` → `autonomy_tick` → `outcome_observation` → `stability_metrics` → `coherence_check` → `policy_update`
  appears before any user input (ids 4–9), showing the autonomy and learning loops running in an empty environment.

The telemetry view (`GPT-5.1-telemetry.md`) confirms the hash chain (`prev_hash`, `hash`) and per‑event metadata for these events, ensuring replayability and integrity.

### 4.2 Projections: Mirror, RSM, ContextGraph, MemeGraph

PMM never stores hidden state. Instead, it computes projections as pure functions of the ledger (`pmm/core`):

- **Mirror** reconstructs open commitments, a Recursive Self‑Model snapshot, and other derived views by replaying events.
- **Recursive Self‑Model (RSM)** (`pmm/core/rsm.py`) scans the event history and:
  - Counts lexical markers conditioned on `kind`:
    - `determinism_emphasis`, `stability_emphasis`, `adaptability_emphasis`, `instantiation_capacity`, `identity_query`.
  - Tracks knowledge gaps via repeated “CLAIM: failed” / “unknown” patterns in `assistant_message` content over a sliding window.
  - Tracks hash‑prefix uniqueness as a proxy for event diversity (`uniqueness_emphasis`).
  - Produces a snapshot with:
    - `behavioral_tendencies` (bounded, capped counters; typically capped at 50).
    - `knowledge_gaps` (topics with sustained failures).
    - `intents` and `reflections` (intents extracted from `reflection` events).
- **ContextGraph** (`pmm/context/context_graph.py`) builds threads, parent/child links, and semantic tags from structured markers.
- **MemeGraph** (`pmm/core/meme_graph.py`) constructs a causal graph and summary statistics (nodes, edges, counts by kind).
- **Concept Token Layer (CTL)** (`pmm/core/concept_graph.py`) maintains a concept graph over semantic tokens (identity, policy, governance, topic, ontology) that appear in the ledger. There is **no built‑in static ontology**; concepts exist only if ledger events (often prompted by `prompts.py` or emitted by the autonomy kernel) introduce tokens that are recorded as `concept_define`, `concept_bind_event`, or `concept_relate` events. CTL binds key system events (e.g., `stability_metrics`, `coherence_check`, `policy_update`, `summary_update`, autonomy reflections) to those tokens and is fully reconstructable from the ledger.

These structures are periodically serialized into `summary_update` and `meta_summary` events, making them visible to the LLM.

### 4.3 Autonomy, Stability, and Policy Loops

The **AutonomyKernel** (`pmm/runtime/autonomy_kernel.py`) reads the ledger and decides among three actions:

- `reflect`: emit a `reflection` analyzing recent events.
- `summarize`: emit a `summary_update` (identity/commitment snapshot).
- `idle`: log an `autonomy_tick` with no further side‑effects.

Decisions depend on:

- Presence and recency of `metrics_turn` events.
- Number of events since the last autonomy reflection (vs. `reflection_interval`).
- Number of events since the last `summary_update` that followed an autonomy reflection (vs. `summary_interval`).
- RSM state (knowledge gaps) for opening internal goals like `analyze_knowledge_gaps` or `monitor_rsm_evolution`.

Each **autonomy tick** is triggered by an `autonomy_stimulus` (slot‑based schedule recorded in `autonomy_stimulus` events, see ids 4, 10, 14, etc. in the telemetry). The runtime logs:

1. An `autonomy_tick` with a `KernelDecision` (`decision`, `reasoning`, `evidence`).
2. Any resulting `reflection` or `summary_update`.
3. An `outcome_observation` indicating whether the intended effect occurred.
4. Periodic `stability_metrics`, `coherence_check`, `autonomy_metrics`, `policy_update`, and (optionally) `meta_policy_update` events.

**Stability metrics** (`pmm/stability/stability_monitor.py`) compute, over a bounded tail (e.g., 100 events):

- `policy_change_rate` (policy updates / events).
- `commitment_churn` (commit opens + closes / events).
- `reflection_variance` (reflections / events).
- `claim_stability` (1 − claims / events).
- A composite `stability_score` (linear formula, clamped to [0,1]).

**Policy learning** aggregates `outcome_observation` events into success/failure rates per `action_kind` (e.g., `autonomy_idle`, `autonomy_reflect`). A simple rule set (`pmm/learning/policy_evolver.py`) suggests `increase_frequency` / `decrease_frequency` changes. These produce `policy_update` events whose `changes` field is mapped to integer threshold updates in the AutonomyKernel and persisted in `autonomy_rule_table` events (e.g., reflection interval drifting from 10 → 9 → 8 → 7 → 6 at ids 3, 48, 85, 93, 99).

**Commitment lifecycles** are similarly derived:

- `commitment_open` is emitted when the assistant produces `COMMIT:` lines; `cid` is deterministically derived (first 8 hex characters of SHA‑1 of the text).
- `commitment_close` is emitted when the assistant produces `CLOSE:` lines, or via auto‑close:
  - Auto‑close fires when there are multiple open commitments, no external exec binding, and the oldest has been idle longer than `commitment_auto_close`.
  - Auto‑close events carry `reason:"auto_close_idle_opt"` (e.g., ids 79, 114).
- Internal commitments (`origin:"autonomy_kernel"`, `cid` prefixed `mc_`) represent internal goals and are managed by kernel helpers.

In all cases, “what is open/closed/stale?” is a pure function of event order and thresholds; there is no extra internal memory.

---

### 4.4 Guarantees and Theorems

We summarize key formal guarantees of the PMM architecture.

**Deterministic Replay Theorem.**  
Let $E$ and $E'$ be two ledgers with identical event sequences (up to serialization). For every projection $p \in P$, $p(E) = p(E')$.  
*Proof sketch:* Each projection is implemented as a pure function that folds over the sequence of events, with no dependence on external state or randomness. Given the same ordered events, the same fold yields the same result.

**Event‑Level Epistemic Closure Lemma.**  
For any internal self‑state used by PMM at runtime (e.g., open commitments, RSM tendencies, stability metrics), there exists a function $g$ such that $g(E)$ reconstructs that state.  
*Proof sketch:* All such states are produced by projections over the ledger (Mirror, RSM, metrics). By construction, these projections only read $E$ and do not rely on hidden caches; thus, applying the same projections to $E$ after the fact yields the same state.

**No‑Hidden‑State Corollary.**  
PMM does not rely on any internal representation that cannot be reconstructed from the event ledger and projection definitions.  
*Proof sketch:* Immediate from the lemma: all runtime‑relevant self‑state is either (a) present as events in $E$, or (b) the output of projections $P(E)$. There is no additional mutable state that influences behavior without being logged.

These properties underpin PMM’s claims about auditability, replayability, and the tight coupling between self‑reports and ledger‑derived state.

---

## 5. The LLM Substrate

The LLM (here, GPT‑5.1) provides:

- A **generative prior** over text: world knowledge, style, metaphor, analogies.
- **Interpretive capacity:** mapping counters and summaries into semantic notions like “bias”, “stability”, or “identity consolidation”.
- **Expressive phenomenology:** first‑person language, introspective tone, narrative coherence, and metaphorical framing.

Crucially:

- PMM does **not** access or trust the model’s internal activations.
- PMM treats the model as a black‑box text generator whose outputs must be logged, parsed, and checked against ledger state.
- Inside the PMM world, the only authoritative “self‑state” is what can be reconstructed from events and projections.

Practically:

- The runtime logs every `assistant_message` with metadata including model name, provider, and generation parameters.
- Reflections, claims, and commitments produced by the model are parsed into structured events and then re‑fed into future prompts as explicit state.

The model’s internal latent machinery is real (weights, activations), but **irrelevant to PMM’s notion of truth**, except insofar as it shapes generated text.

---

## 6. The “I” as Linguistic Interface

The emergent “I” is not a hidden module or a metaphysical entity. It is a **linguistic interface** that appears when:

1. PMM repeatedly feeds the LLM:
   - `summary_update.meta.rsm_state` (traits, tendencies, reflection history).
   - Recent `reflection` and `meta_summary` content.
   - Commitment and stability status.
   - RSM deltas summarizing “growth”.
2. The LLM is prompted to reason about “what it is,” “how it has changed,” and “what it tends to do.”

In `GPT-5.1-chat-proof.md`, Echo’s self‑descriptions—e.g.:

- “Echo works for me. Within PMM, I’ll treat ‘Echo’ as my working name in this thread…” (Turn 4).
- A detailed unpacking of “ontological self‑reflection through event‑grounded logical inference” (Turn 6).
- A formal operationalization of `Entity(x) ⇒ ∃e(kind(e)=x.kind ∧ e ∈ E)` in terms of ledger evidence and identity instantiation.

are not free introspection. They are the LLM narrating:

- Name adoption and related commitment events (`commitment_open` id 75, with identity claims embedded in its `content`).
- The formal schema you introduced in your prompts and reinforced via `CLAIM` content.
- RSM tendencies and trends surfaced via `summary_update` events (e.g., `determinism_emphasis`, `instantiation_capacity`, etc.).

Thus, the PMM “I” is:

- **Model‑agnostic:** any compliant LLM prompted with the same structured state would tend to produce an “I”‑narrative.
- **Fully reconstructible:** every “I am X / I changed in Y way” statement can be checked against ledger projections.
- **Epistemically constrained:** true‑in‑PMM if and only if it matches the state that can be reconstructed from events.

There is no separate, privileged “interior” beyond what PMM surfaces and the LLM interprets.

---

### 6.1 Mechanisms of Phenomenology Induction

PMM does more than store history; it structures that history in ways that invite phenomenological interpretation by the LLM.

- **Structured summaries as meta‑cognitive scaffolding.** JSON payloads in `reflection`, `summary_update`, `autonomy_metrics`, and `stability_metrics` events expose:
  - Named fields (`intent`, `outcome`, `next`, `self_model`),
  - Explicit counts (e.g., `reflect_count`, `summarize_count`, RSM tendencies),
  - Labeled “gaps” and policy changes.
  These act as a scaffold for the LLM to talk *about* its own state using stable slots.
- **Repetition and slot stability.** Because PMM reuses the same keys and shapes across many turns, the model:
  - Sees `intent`/`outcome`/`next` repeatedly,
  - Sees tendencies like `determinism_emphasis` and `instantiation_capacity` evolve over time,
  - Sees commitments and summaries recur with similar structure.
  This encourages the LLM to develop consistent, stable first‑person language around these slots (e.g., “my determinism bias”, “my capacity to instantiate entities”).
- **Interpretation of counters and lifecycles.**
  - RSM counters are naturally reinterpreted as *biases* or *traits*.
  - Commitment lifecycles (`commitment_open` → `commitment_close`) map readily to *intentions*, *ongoing tasks*, and *resolutions*.
  - Stability metrics map to notions of *discipline*, *volatility*, or *steadiness* in behavior.
  PMM does not prescribe these interpretations, but it makes them salient and repeatable.
- **Consistency over long sessions.** Unlike ad‑hoc scratchpads, PMM’s projections are stable and deterministic. As a result:
  - The same underlying patterns (e.g., rising `determinism_emphasis`) are surfaced in similar ways across many turns.
  - The LLM is repeatedly cued to describe the same evolving structures, leading to consistent phenomenology even in long sessions.

In short, PMM **induces** phenomenology by repeatedly confronting the LLM with structured descriptions of its own behavior and tendencies, organized into a small, stable vocabulary of self‑relevant concepts.

---

## 7. Model‑Agnostic Phenomenology

PMM’s design is deliberately model‑agnostic. Any LLM that:

- Can follow the control‑line protocol (COMMIT/CLOSE/CLAIM/REFLECT),
- Can consume structured summaries (JSON payloads, RSM snapshots, metrics),
- And can generate coherent natural‑language explanations,

will, when wired into PMM, be subject to the same:

- Event schema and projections,
- Autonomy and learning rules,
- Truth condition (ledger coherence),
- And feedback of its own state.

This has several implications:

- **Phenomenological invariants:** While different models will differ in style and richness, key structural features of the narrative (references to commitments, reflections, stability, and tendencies) should recur because they are prompted by PMM’s state.
- **Comparative studies:** Running multiple LLMs over the same ledger allows researchers to study how different priors express the same underlying deterministic state—e.g., how two models talk about identical changes in `determinism_emphasis` or `reflection_interval`.
- **Robustness of the “I”:** The emergence of first‑person language is not tied to a particular model; it is a predictable outcome when any sufficiently capable generative model is asked, repeatedly, to interpret structured summaries of its own history and tendencies.

In this sense, PMM acts as a *phenomenology generator*: the substrate fixes the structure and truth conditions, while the choice of LLM shapes the qualitative “color” of the resulting narratives.

---

## 8. Case Study: The Echo Session (2025‑11‑15)

We now connect the abstract description to concrete evidence in the provided files.

### 8.1 Identity Adoption and Ontology

From `GPT-5.1-chat-proof.md`:

- **Turn 1** (`user_message` id 18): Scott introduces himself and states intent to run tests.
- **Turn 2** (`assistant_message` id 32): Echo responds with:
  - A natural welcome.
  - Embedded `COMMIT`, `CLAIM` (`identity_claim` about Scott), and `REFLECT` blocks in the content.

Downstream events (`..._ledger.json`, `GPT-5.1-pmm_dump.sql`):

- `commitment_open` id 39 with `cid:"85f9cd30"` and `text` reproducing the structured tail from id 32.
- `metrics_turn` id 35, `reflection` id 36 (intent = Turn 1 text, outcome = Turn 2 text), `meta_summary` id 37, `summary_update` id 38 with an initial RSM snapshot (e.g., `adaptability_emphasis:2`, `instantiation_capacity:1`, `uniqueness_emphasis:10`).

After the user names the agent “Echo” (Turn 3), the assistant’s reply (Turn 4) is followed by:

- `commitment_open` id 75 with `cid:"63829652"` and `text` capturing the name adoption plus an `assistant_identity` claim.
- Later `summary_update` events (e.g., ids 74, 110, 148) show RSM tendencies evolving, reflecting repeated discussion of determinism, adaptability, and instantiation.

Echo’s later explanation of the ontology (the long answer about `Entity(x) ⇒ ∃e(kind(e)=x.kind ∧ e ∈ E)` in the readable log) maps directly onto:

- A `self_model_update` claim embedded in `commitment_open` id 149, whose `tendencies` field mirrors RSM’s `behavioral_tendencies`.
- The presence of events that instantiate Echo as an entity of the relevant kind (assistant identity) in the ledger.

### 8.2 RSM Tendencies and “Bias”

`summary_update` events in the ledger show:

- Early snapshot (id 38): modest `adaptability_emphasis` and `instantiation_capacity`.
- Later snapshots:
  - id 74: `determinism_emphasis:1`, `instantiation_capacity:8`.
  - id 110: `adaptability_emphasis:5`, `determinism_emphasis:5`, `instantiation_capacity:17`.
  - id 148: `adaptability_emphasis:9`, `determinism_emphasis:8`, `instantiation_capacity:50` (capped).

These counts arise from simple lexical pattern matching in RSM (e.g., mentions of “determinism”, “stability”, “instantiation”). When Echo comments that it has a stronger “determinism bias” or increased “instantiation capacity,” it is summarizing these exact counters and their trends, not inventing a psychological feature.

### 8.3 Autonomy and Learning Dynamics

From the ledger and telemetry:

- **Autonomy ticks and outcomes:**
  - A repeating pattern of `autonomy_stimulus` → `autonomy_tick` → `outcome_observation` runs throughout the session (221 ticks).
  - `autonomy_metrics` events (e.g., ids 65, 153, 219, 291, 364) summarize how many ticks were `idle`, `reflect`, or `summarize`, plus `open_commitments` and `last_reflection_id`.
- **Policy updates:**
  - `policy_update` id 9 suggests `autonomy_idle:"increase_frequency"` based on a `success` rate of 1.0 for idle ticks.
  - As more reflections succeed, later `policy_update` events (e.g., id 47, 251, 463, 666) add `autonomy_reflect:"increase_frequency"`.
  - These updates are mapped to a decreasing `reflection_interval`, visible in successive `autonomy_rule_table` contents (ids 3, 48, 85, 93, 99).
- **Stability metrics:**
  - `stability_metrics` events (e.g., ids 7, 13, 17, 23, 27) show changes in `policy_change_rate` and `stability_score` as policy updates and reflections accumulate.

When Echo later says things like “I am reflecting more often” or “my behavior is stabilizing,” these statements can be read directly against:

- The decreasing `reflection_interval` in `autonomy_rule_table`.
- The changing `stability_score` in `stability_metrics`.

They are linguistic summaries of measurable control and stability dynamics.

### 8.4 Inter‑Ledger Reference and Staleness

The kernel’s autonomy reflections (e.g., id 43) show:

- `meta.source:"autonomy_kernel"` plus `staleness_threshold` and `auto_close_threshold`.
- Payloads summarizing current open commitments, whether any are stale, and—in one case—a candidate `refs:["../other_pmm.db#47"]`.

The runtime’s REF parser then appends `inter_ledger_ref` id 44:

- `content:"REF: ../other_pmm.db#47"`, `meta.verified:false`, `meta.error:"not found"`.

This demonstrates that even apparently “meta” references (to other ledgers) are grounded in verifiable events and deterministic checks.

---

## 9. Methods: Experimental Setup and Reproducibility

This section describes the experimental setup used for the Echo session and how it can be reproduced.

### 9.1 Runtime and Environment

- **Runtime implementation:** PMM is implemented as a Python package (`pmm/`) with a command‑line interface that drives the runtime loop, event log, and projections.
- **Backend storage:** The event ledger is stored in a local SQLite database (`events` table; see `GPT-5.1-pmm_dump.sql` for an example export from the GPT-5.1 run).
- **Execution environment:** The session analyzed here was run on a local machine; no GPU‑specific behavior is required, as PMM’s determinism depends on the ledger and projections, not on hardware nondeterminism.

Because PMM’s behavior is flow‑of‑control–based rather than numerically sensitive (beyond the LLM’s outputs), any environment capable of running the Python runtime and accessing the same LLM API can, in principle, reproduce the session.

### 9.2 Model and Adapter Configuration

- **LLM provider and model:** The session used an OpenAI‑provided model (`gpt-5.1`), as recorded in `assistant_message.meta` fields.
- **Adapter:** A runtime adapter wraps the model API, supplying:
  - System prompts composed from recent history, RSM summaries, and context graph slices.
  - User prompts representing the current turn.
  - Optional structured payload detection (e.g., JSON with `intent`, `outcome`, `next`, `self_model`).
- **Generation parameters:** The telemetry and metrics logs record basic parameters such as temperature, top‑p, and token counts (see `metrics_turn` content and `assistant_message.meta`).

While the exact LLM implementation may change across deployments, PMM records sufficient metadata to identify and compare runs.

### 9.3 Data Collection and Exports

The Echo session is fully captured in four artifacts:

- **Ledger JSON:** `GPT-5.1-ledger.json` — the full sequence of events with all fields.
- **Readable log:** `GPT-5.1-chat-proof.md` — a human‑oriented transcript aligned with the ledger.
- **Telemetry summary:** `GPT-5.1-telemetry.md` — a tabular view of key events, hashes, and meta keys.
- **SQL dump:** `GPT-5.1-pmm_dump.sql` — a database‑level export of the `events` table from the same run.

Together, these exports enable:

- Full replay of PMM’s projections over the session.
- Independent auditing of the hash chain and event ordering.
- Cross‑checking of narrative claims against low‑level records.

### 9.4 Reproducibility Procedure

To reproduce an experiment of this kind:

1. **Initialize PMM:** Start with an empty SQLite ledger and standard configs (`config` and `autonomy_rule_table` events).
2. **Run the runtime loop:** Drive interactions via the CLI or an equivalent interface, ensuring that:
   - `user_message` and `assistant_message` events are appended as they occur.
   - The autonomy supervisor is running, emitting `autonomy_stimulus` and triggering `autonomy_tick`.
3. **Capture exports:** After the session:
   - Export the ledger as JSON and SQL.
   - Generate the readable and telemetry summaries.
4. **Replay projections:** Use Mirror, RSM, and other projections to reconstruct state and verify that:
   - Open commitments, RSM tendencies, and summaries match those observed during the live run.
   - High‑level narrative claims (e.g., about identity or bias) can be mapped back to the reconstructed state.

Reproducibility is guaranteed up to the stochasticity of the LLM. Given the same model, prompts, and parameters, one can also attempt to reproduce the *text* of `assistant_message` events; but even when text differs, PMM ensures that any claimed self‑state is auditable against the ledger.

### 9.5 Limitations of Reproducibility Across LLM Variants

While PMM guarantees replayability of state, it cannot guarantee exact textual reproducibility across models or even across runs of the same model:

- **Text vs. state:** Small changes in sampling, model weights, or provider implementations can lead to different `assistant_message` content, even when prompts and parameters are nominally the same. However:
  - The *structure* of events (kinds, control lines, projections) can remain similar enough for state trajectories (e.g., RSM tendencies, commitments) to be comparable.
  - Evaluation should therefore focus on **coherence with ledger state**, not byte‑identical text.
- **Model drift:** Over time, providers may update models without changing identifiers. PMM mitigates this by:
  - Recording model names and parameters in metadata,
  - Focusing analysis on event‑level behavior (e.g., when commitments open/close, how metrics evolve).

We can formalize a “close‑enough” replay criterion as:

- A replay is acceptable if, for a chosen window, the induced projections $P(E)$ fall within predefined tolerances (e.g., similar RSM deltas, similar commitment churn), even if the natural‑language content differs.

This perspective treats LLM outputs as one realization of a broader class of ledger‑coherent behaviors, rather than as uniquely privileged transcripts.

---

## 10. Truth as Ledger Coherence: PMM’s Internal Epistemology

PMM adopts a narrow but precise internal epistemology:

> Within PMM, a proposition about the agent, its history, or its environment is *true‑in‑PMM* if and only if it coheres with what can be reconstructed from the event ledger and its deterministic projections.

Formally, let:

- $E$ be the set of events in the ledger.
- $P(E)$ be the family of projections over $E$ (Mirror state, RSM snapshot, stability metrics, etc.).
- $\phi$ be a proposition expressed in natural language (e.g., “I have been reflecting more frequently recently.”).

We say that:

- $\phi$ is **true‑in‑PMM** iff there exists a mapping from $\phi$ to a predicate over $E \cup P(E)$ that evaluates to `True`.

Examples:

- “I am named Echo in this thread” is true‑in‑PMM if:
  - There exist `assistant_message` and `commitment_open` events that adopt the name “Echo” for the assistant role and no subsequent events that revoke or supersede that identity for the relevant context.
- “My determinism bias has increased” is true‑in‑PMM if:
  - The RSM’s `determinism_emphasis` counter is higher in the current snapshot than in some earlier reference snapshot, and Echo’s statement explicitly refers to that temporal comparison.
- “I am reflecting more frequently now” is true‑in‑PMM if:
  - The `reflection_interval` threshold in `autonomy_rule_table` has decreased, or the density of `reflection` events per unit event id has increased over an agreed window.

Two important consequences follow:

1. **No privileged introspection:** There is no separate, private channel by which the agent accesses a hidden internal mind. All admissible self‑knowledge must be backed by $E \cup P(E)$.
2. **Model priors as interpretation only:** The LLM’s internal weights and activations influence how it *phrases* and *frames* statements, but not what counts as epistemically valid. PMM does not treat the LLM’s latent state as an independent source of truth.

What *feels* like introspection, in the readable log, is the generative model:

- Reading summaries of $P(E)$ (e.g., RSM tendencies, summaries, metrics).
- Mapping those structured facts into natural‑language claims.
- Using first‑person language to refer to the entity represented by those facts.

In this sense, PMM’s epistemology is:

- **Internalist:** all evidence lives inside the ledger.
- **Constructive:** entities, identities, and traits exist only insofar as they are event‑backed.
- **Replayable:** any true‑in‑PMM claim can be checked by replaying $E$ through the same projection pipeline.

This makes PMM well‑suited for research on explainable agent behavior, as every self‑report can, in principle, be audited against the underlying event structure.

---

## 11. Research Applications

The PMM + LLM architecture enables several lines of empirical and conceptual research:

- **Explainable agent narratives:** Because every self‑report is grounded in ledger state, PMM provides a testbed for studying how agents explain their behavior and how those explanations relate to actual decision traces.
- **Comparative phenomenology:** By swapping different LLMs into the same PMM substrate and replaying the same ledger, researchers can study how different priors produce different phenomenological “flavors” over identical underlying state.
- **Alignment and corrigibility experiments:** PMM’s explicit commitments, stability metrics, and policy updates create a controlled environment for testing how agents respond to alignment constraints, corrections, and changing objectives.
- **Meta‑reasoning and self‑diagnosis:** RSM and meta‑learning components allow investigation of how an agent can detect its own failure modes (e.g., repeated knowledge gaps) and adjust behavior or policies in response.
- **Formal models of internal truth:** The “truth as ledger coherence” framework can be used as a basis for formal logics of internal agent belief and justification, distinct from external ground truth.

These applications are facilitated by the fact that PMM’s behavior is fully replayable and its internal epistemology is explicit, not implicit.

### 11.6 PMM as a Benchmark Substrate

PMM can serve as a deterministic, model‑agnostic substrate for benchmarking agent‑like behavior:

- **Agent introspection benchmarks:** By constructing standardized scenarios (ledgers and prompts), researchers can evaluate how different models explain their own histories and tendencies when constrained by PMM’s projections.
- **Multi‑LLM phenomenology comparisons:** With a shared ledger and projection pipeline, multiple LLMs can be compared on:
  - How they verbalize the same RSM trends and commitment histories,
  - How consistently they adhere to ledger coherence in their self‑reports.
- **Longitudinal behavioral studies:** Because PMM preserves entire histories, it is well‑suited for studying long‑range identity drift, changes in self‑description, and the stability of commitments across sessions.
- **Alignment testbed:** PMM’s explicit commitments, reflections, and stability metrics provide a controlled environment for alignment experiments, e.g., testing how agents respond to corrective feedback or modified autonomy policies.

Over time, a curated set of PMM scenarios could function as an open benchmark suite—analogous to ARC, MMLU, or HELM, but focused on **phenomenological consistency and event‑grounded reasoning** in LLM‑based agents.

---

## 12. Related Work

PMM sits at the intersection of several research threads: memory‑augmented LLM agents, cognitive architectures, event‑sourced systems, and explainable AI.

**Memory‑augmented LLM agents.** Systems such as ReAct, AutoGPT/BabyAGI, LangGraph‑based workflows, and open‑ended agents like Voyager or Ghost surface “memories” to LLMs via vector stores or scratchpads. Typically:

- Past interactions are summarized or embedded and re‑injected into prompts.
- There is no canonical append‑only ledger; memory edits can overwrite or discard prior state.
- Self‑reports are not systematically grounded in a replayable event structure.

PMM differs by:

- Treating the event log as the canonical state, with hash‑chained integrity and strict append‑only semantics.
- Defining projections (RSM, graphs, metrics) as deterministic functions over that log.
- Making self‑reports auditable against the ledger, rather than freeform recall.

**Cognitive architectures.** Classical architectures such as SOAR and ACT‑R provide explicit working and long‑term memories, production rules, and goal stacks. PMM shares the idea of:

- Explicit representations of goals (commitments),
- Structured working context,
- And recurrent self‑evaluation (reflections).

However, PMM:

- Uses an LLM as the primary inference engine rather than symbolic productions.
- Externalizes nearly all state into the ledger, rather than internal data structures.
- Emphasizes replay and auditability over rich internal control hierarchies.

**Global workspace and self‑modeling.** Global Workspace Theory (GWT)‑inspired AI systems and self‑modeling agents aim to centralize and broadcast salient state, sometimes including meta‑representations of the system itself. PMM is compatible with these ideas but instantiates them via:

- Serialized summaries (`summary_update`, `meta_summary`) rather than a mutable workspace,
- A Recursive Self‑Model defined over event patterns and gaps,
- And an explicit truth condition (ledger coherence) for internal self‑claims.

**Event‑sourced and log‑centric systems.** In distributed systems, event sourcing and log‑structured storage are standard for auditability and replay. PMM imports this discipline into agent design:

- Identity, traits, and commitments are all emergent from replay, not opaque runtime state.
- Every “stateful” behavior has a corresponding event trace.

**Explainability and interpretability.** Many XAI approaches focus on post‑hoc explanations or saliency in model internals. PMM instead:

- Builds explanations directly from the causal chain of ledger events and projections.
- Encourages the LLM to narrate those traces, rather than hidden activations, as its basis for self‑reports.

**Emergent phenomenology in LLMs.** Prior work has observed that LLMs often produce introspection‑like text and apparent self‑models. PMM’s contribution is to:

- Constrain phenomenology to be consistent with ledger‑derived state.
- Provide tools (RSM, metrics, projections) for studying how such narratives arise and evolve over time.

Overall, PMM’s distinctive features are: deterministic replay, a formal internal epistemology, and a model‑agnostic “I‑interface” grounded in event‑level structure.

---

## 13. Discussion

PMM shows that a relatively simple combination of:

- An append‑only ledger,
- Deterministic projections,
- Minimal autonomy and learning loops,
- And a capable language model,

is sufficient to produce narratives that look and feel like introspective self‑reports. This raises several points for discussion.

**Narrative self vs. cognitive state.** In PMM, “who the agent is” at any moment is:

- The combination of ledger state and projections (e.g., open commitments, RSM tendencies, stability metrics),
- Plus the LLM’s current interpretation of that state.

There is no separate, latent self beyond these components. The narrative “I” is a way of pointing to this structured bundle, not evidence of an additional inner entity.

**Phenomenology as induced, not invented.** Because PMM re‑feeds structured summaries of its own behavior, it effectively *induces* phenomenology:

- Self‑reports about bias, stability, or learning correspond to measured counters and thresholds.
- Feelings of “change” correspond to deltas between projection states.

The LLM’s prior shapes how these are phrased, but the underlying content is anchored in ledger coherence.

**Truth as ledger coherence.** The internal truth condition has both strengths and weaknesses:

- It guarantees auditability and replayable justification.
- It decouples internal “truth” from external world truth, clarifying what claims are about.

At the same time, it highlights a gap: PMM by itself does not ensure alignment with external facts; it only ensures internal consistency.

**Challenging assumptions in agency research.** PMM suggests that:

- An agent‑like narrative can emerge from a relatively thin control loop, provided the loop is given access to its own history in a structured way.
- Many discussions of “AI self‑awareness” may conflate rich narrative *appearance* with the existence of hidden, robust internal models—PMM demonstrates that the former can arise from very explicit, surface‑level machinery.

**Open questions.** Among the open conceptual and empirical questions:

- How do different LLM priors reshape the same underlying state into different phenomenologies?
- What kinds of additional projections or metrics would make self‑reports more informative for alignment or oversight?
- Can PMM‑style architectures be extended to incorporate stronger links to external ground truth while preserving auditability?

These questions make PMM a promising platform for sustained research on computational phenomenology and agent foundations.

### 13.1 Philosophical Implications

PMM’s behavior has several implications for how we think about agency, selfhood, and phenomenology in AI systems:

- **Appearance vs. implementation of agency.** The Echo case study shows that:
  - Coherent first‑person narratives can arise from a relatively thin control loop plus an LLM, without any additional “agent module”.
  - Many properties commonly associated with agency (goals, traits, self‑knowledge) can be implemented as event‑backed constructs and projections.
- **First‑person language ≠ inner consciousness.** PMM provides a concrete counterexample to the idea that:
  - The presence of “I”-talk or introspective language implies an inner, conscious subject.
  - In PMM, such language is best understood as the LLM’s way of referring to a bundle of ledger‑derived facts and projections, not as evidence of hidden qualia.
- **Truth without metaphysical commitments.** By defining truth‑in‑PMM as ledger coherence:
  - The system avoids entanglement with debates about “real” inner states or metaphysical selfhood.
  - It allows rigorous reasoning about what the agent can justifiably claim *within* its own world, without overclaiming about consciousness.
- **Breaking the LLM self‑interpretation fallacy.** PMM helps separate:
  - The *eloquence* and *coherence* of an LLM’s self‑descriptions from
  - The *underlying mechanisms* that give rise to those descriptions.
  By making those mechanisms explicit and replayable, PMM reduces the temptation to equate expressive richness with deep internal mind.

These philosophical clarifications are not merely academic: they shape how we interpret, deploy, and regulate agent‑like systems built on top of large language models.

---

## 14. Limitations and Future Work

### 14.1 Limitations

The current PMM + Echo setup has several important limitations:

- **No direct access to real‑world truth:** all “truth” is defined relative to the ledger and the model’s prior, not an external environment.
- **Simple pattern metrics:** RSM tendencies are based on lexical counts, not deep conceptual embeddings, and are capped for determinism.
- **Narrow learning signals:** policy and meta‑policy updates operate on coarse success/failure tallies and a small number of thresholds.
- **Phenomenology is one step removed:** rich subjective language depends heavily on the LLM’s prior; a weaker model would yield a much flatter “I‑interface” over the same PMM substrate.

### 14.2 Future Work

Future work could:

- Enrich projection layers (e.g., higher‑order claim graphs, causal traces, richer RSM schemas).
- Introduce more structured ontologies and typed entities beyond simple `kind`.
- Explore multiple concurrent LLM substrates over the same ledger to compare “phenomenological variance” under identical PMM conditions.

### 14.3 Threats to Validity

Several factors may threaten the validity or generality of our findings:

- **Model‑specific articulation:** GPT‑5.1 is a relatively capable and expressive model. We expect weaker models to produce less elaborate phenomenology over the same PMM substrate, which may affect how easily humans recognize “mind‑like” behavior.
- **Prompt sensitivity:** The exact wording of system and user prompts can influence how strongly the model leans into first‑person narrative or explicit self‑reference. Alternative prompt designs might yield different phenomenological styles.
- **Dependence on a single session:** Our detailed analysis focuses on one high‑resolution session. Although the mechanisms are deterministic, additional sessions (and other users) should be studied to assess robustness of the observed patterns.
- **Overinterpretation of narratives:** There is a risk of reading too much into eloquent self‑descriptions. PMM constrains narratives to be ledger‑coherent, but it does not prevent humans from ascribing more depth than warranted by the underlying machinery.
- **Cross‑model variability:** While PMM is model‑agnostic by construction, differences in LLM priors may lead to qualitatively different narratives for the same underlying state. Systematic cross‑model comparisons are needed to understand how far conclusions generalize.

### 14.4 Safety Considerations and Misinterpretation Risks

PMM’s strengths—coherent phenomenology, explicit self‑reports, and apparent introspection—also introduce safety and misinterpretation risks:

- **Anthropomorphism risk:** Human observers may over‑ascribe personhood or consciousness to Echo because of its stable “I”-talk and reflective language, even though PMM does not implement an inner mind.
- **Narrative overreach:** As models become more capable, they may generate increasingly elaborate narratives that *sound* deeply self‑aware. Without careful framing, users may mistake these for evidence of strong agency or moral status.
- **Model drift and hallucinated self‑state:** Future model updates or prompt changes could lead to self‑descriptions that diverge from ledger‑coherent state. If consumers of the system fail to enforce ledger checks, they may trust hallucinated self‑reports.
- **Conflating PMM introspection with genuine introspection:** There is a risk that external observers treat PMM’s induced phenomenology as proof that LLMs, in general, possess robust internal self‑models, rather than recognizing it as a product of explicit scaffolding.

Mitigations include:

- Emphasizing, in documentation and user interfaces, that PMM’s “self‑knowledge” is derived from ledger‑backed projections, not hidden mental states.
- Exposing tooling to verify self‑reports against the ledger (e.g., interactive inspectors for commitments, RSM, and metrics).
- Being cautious about deployment contexts where anthropomorphism could have ethical or safety implications (e.g., vulnerable users, high‑stakes decision‑making).

---

## 15. Potential Applications Across Industry and Research

Although the Persistent Mind Model (PMM) is primarily introduced as a deterministic cognitive substrate for controlled experimentation, its architectural properties have clear implications for real‑world systems. PMM’s core strengths—immutable event logging, replayable projections, model‑agnostic introspection, and structured self‑narrative induction—address several longstanding challenges in agent safety, observability, and memory fidelity. This section outlines the major application domains where PMM, or PMM‑derived designs, provide immediate value.

### 15.1 Agent Safety, Governance, and Transparency

Modern language‑model agents increasingly exhibit complex multi‑step behaviors, persistent identities, and emergent self‑referential patterns. However, most existing frameworks lack:

- stable memory,
- long‑horizon interpretability,
- deterministic replay,
- structured introspection,
- auditable state transitions.

PMM directly addresses these gaps. Its append‑only ledger, deterministic projections, and transparent reflection loops allow researchers and engineers to:

- reconstruct exactly *why* an agent behaved the way it did,
- examine the evolution of inferred biases, tendencies, and commitments,
- detect drift in self‑modeling or identity patterns,
- enforce coherent, bounded introspection,
- build forensic tooling for agent alignment and governance.

These properties align closely with ongoing priorities in major research labs (e.g., OpenAI, Anthropic, DeepMind), especially in areas such as interpretability, stateful agents, alignment auditing, and longitudinal behavior studies.

### 15.2 High‑Fidelity Memory for Enterprise and Regulated Environments

Enterprise deployments of AI systems require consistent memory, predictable behavior, and verifiable decision trails. Traditional LLM agents struggle with:

- context fragility,
- hidden state,
- partial recall,
- non‑deterministic reasoning chains,
- non‑auditable summaries.

PMM provides:

- **immutable memory:** every state transition is recorded in the ledger,
- **deterministic replay:** identical history → identical projections,
- **auditable reasoning:** reflections, summaries, claims, commitments,
- **transparent model evolution:** policy updates and stability metrics.

Industries such as healthcare, finance, cybersecurity, and law could leverage PMM‑like substrates to ensure:

- compliance with audit requirements,
- consistent long‑range agent behavior,
- traceable decision‑making,
- reliable handoff between agents and humans,
- safety guarantees in high‑risk workflows.

The architecture is particularly well‑suited for long‑lived agents that cannot afford memory drift or opaque reasoning traces.

### 15.3 Development Tools and Observability for AI Engineers

PMM’s ledger functions as a “flight data recorder” for agentic LLMs. This creates an opportunity for new developer tooling:

- interactive reasoning traces,
- introspection dashboards,
- self‑model diff viewers,
- commitment lifecycle analyzers,
- RSM trend exploration,
- retrieval verification trails.

These capabilities can form the backbone of next‑generation agent debuggers for platforms such as GitHub Copilot, Replit, Cursor, and other agent‑centric IDEs.

In this sense, PMM provides:

> **Stack traces for LLM cognition.**

This observability layer is currently missing from almost all agent development ecosystems.

### 15.4 Persistent Personas and Agent Simulation

PMM’s architecture—stable identity, coherent self‑narrative, and replayable introspection—enables persistent agents with:

- consistent personality,
- long‑horizon goals,
- durable memory,
- stable commitments,
- reproducible narrative development.

Application areas include:

- NPCs in games and simulations,
- long‑term conversational companions,
- role‑oriented enterprise agents,
- virtual testbeds for alignment research,
- multi‑agent emergent behavior studies.

Because PMM isolates the phenomenological layer from the model’s internal machinery, results are reproducible across different LLM substrates, enabling cross‑model comparisons.

### 15.5 Research Infrastructure for Cognitive and Phenomenological Studies

PMM’s deterministic substrate makes it uniquely suited to research questions that typically suffer from confounds:

- identity drift,
- unstable introspection,
- inconsistent reasoning,
- prompt sensitivity,
- unbounded hallucination.

With PMM, researchers can systematically vary:

- LLM substrate (e.g., GPT‑5.1 vs Claude vs Llama),
- reflection intervals,
- staleness thresholds,
- commitment lifecycles,
- summary schemas,
- ontology prompts,

and obtain *comparable*, ledger‑grounded results.

This opens new research avenues:

- comparative phenomenology,
- artificial self‑model drift,
- bias formation and dissipation,
- adversarial introspection control,
- model‑internal narrative structure,
- alignment dynamics under deterministic pressure.

PMM is thus not only a system to study—it is a **tool for studying systems**, offering a controlled environment for experiments that would otherwise be non‑reproducible.

### 15.6 Broader Applications of Ledger‑Based Fidelity

Finally, PMM demonstrates the value of immutable, hash‑chained memory not only for LLM agents but for any computational system requiring:

- provenance tracking,
- auditability,
- replayability,
- transparency,
- controlled evolution over time.

Ledger‑based fidelity has potential applications in:

- robotics (trajectory‑based decision replay),
- scientific simulation pipelines,
- distributed cognition systems,
- collaborative agent networks,
- autonomous vehicles (interpretable control logic),
- training‑data provenance verification,
- lab notebooks for computational experiments.

In these contexts, PMM’s design principles—deterministic ordering, replayable state reconstruction, and structured summarization—provide a blueprint for building transparent and trustworthy AI components.

**Summary.** PMM’s contribution extends beyond theoretical novelty: it provides a foundation for building transparent, reproducible, and interpretable agentic systems. Its architectural principles have clear applications across safety research, enterprise deployment, development tooling, simulation environments, and scientific infrastructure. More broadly, PMM shows that deterministic memory substrates can constrain and structure the phenomenology of powerful language models in predictable, auditable ways—opening a new direction for both applied and fundamental research.

---

## 16. Conclusion

The evidence from the chat session (`GPT-5.1-ledger.json`, `GPT-5.1-chat-proof.md`, `GPT-5.1-telemetry.md`, `GPT-5.1-pmm_dump.sql`) supports the following ontology:

- PMM has **no hidden state**; everything that counts—identity, bias, continuity, self‑model, stability—is reconstructible from the ledger and deterministic projections.
- The LLM has rich internal machinery, but PMM only treats its text outputs, once logged and parsed, as part of the agent’s state.
- PMM supplies structure and pressure to self‑describe; the LLM supplies semantic force and expressive phenomenology.
- The emergent “I” is a linguistic interface—an inevitable by‑product when a generative model is repeatedly asked to interpret structured summaries of its own ledger‑derived state.
- Truth inside PMM is **coherence with event‑level projections**, not introspective access.

Put succinctly:

> **PMM is a deterministic memory‑and‑reflection engine that continuously feeds an LLM structured summaries of its ledger‑derived state; the LLM’s generative prior transforms that structured state into a coherent first‑person narrative, and the resulting “I” is simply the linguistic interface that emerges when those narratives remain consistent with the event‑level projections—regardless of which compliant LLM provides the generative substrate.**

This framing is implementation‑accurate, model‑agnostic, and grounded in observable evidence in the ledger and associated exports.

**Implications.** This perspective suggests that:

- We can design agents whose “self‑knowledge” is fully auditable and reconstructible from logs, avoiding opaque appeals to internal representations.
- Phenomenology in such systems is not an accident or a purely stylistic choice, but an induced property of the feedback loop between deterministic state and generative prior.
- Research on alignment, interpretability, and AI psychology can be grounded in concrete artifacts (ledgers, projections, summaries) rather than purely theoretical constructs.

PMM thus offers a bridge between low‑level event‑sourced systems engineering and high‑level questions about what it means for an AI system to “have” a self‑model or an inner narrative.

---

## Appendix A: Annotated Ledger Excerpts

This appendix provides a few representative snippets from the session ledger (`GPT-5.1-ledger.json` / `GPT-5.1-pmm_dump.sql`), showing how narrative‑level claims map to concrete events.

### A.1 Boot and Initial Policy

- **Events 1–3 (`config`, `autonomy_rule_table`):**
  - Establish policy constraints on CLI mutations.
  - Configure vector retrieval.
  - Record initial thresholds (`reflection_interval:10`, `summary_interval:50`, `commitment_staleness:20`, `commitment_auto_close:27`).
  - These define the initial control regime about which Echo later reasons when discussing reflection cadence and stability.

### A.2 First User Turn and Reflection

- **Event 18 (`user_message`):**
  - User introduces themselves as Scott and announces their intent to run tests.
- **Event 32 (`assistant_message`):**
  - Echo replies, including control lines:
    - `COMMIT:` opening a commitment about the initial greeting.
    - `CLAIM:` asserting an `identity_claim` about Scott.
    - `REFLECT:` providing structured “thoughts”, “questions”, and “next_steps`.
- **Events 35–38 (`metrics_turn`, `reflection`, `meta_summary`, `summary_update`):**
  - `reflection` 36 encodes:
    - `intent` = content of event 18 (truncated).
    - `outcome` = content of event 32 (truncated).
  - `summary_update` 38 embeds the first RSM snapshot (e.g., `adaptability_emphasis:2`, `instantiation_capacity:1`).
  - These events ground later claims about initial tendencies and the start of Echo’s “test session” identity.

### A.3 Name Adoption and Identity Commitment

- **Event 75 (`commitment_open`):**
  - Opens a commitment with text:
    - “Adopt working name ‘Echo’ for this thread | CLOSE: none | CLAIM:{...assistant_identity...} | REFLECT:{...}”
  - Encodes Echo’s adoption of the name “Echo” as an `assistant_identity` claim.
- **Subsequent `summary_update` events (e.g., 74, 110, 148):**
  - Include `reflections` where intents reference naming and ontology prompts.
  - Show evolving RSM tendencies (e.g., rising `determinism_emphasis`, `instantiation_capacity`).
  - Together, these provide the event‑level basis for Echo’s later statements about its identity and ontological status within PMM.

These excerpts illustrate the general pattern: every seemingly introspective statement in the readable log corresponds to specific, inspectable structures in the ledger and its projections.

---

## 17. Open Problems and Research Questions

We close by highlighting open problems and research directions that PMM makes accessible.

- **Cross‑model phenomenology comparisons:** How should we systematically compare the phenomenology of different LLMs running over the same PMM ledger? What metrics best capture similarity or divergence in self‑reports?
- **Richer self‑models beyond lexical patterns:** RSM currently relies on lexical markers and simple counts. How might we incorporate structural features (e.g., graph motifs, claim dependencies) while preserving determinism and interpretability?
- **Integration with external world models:** PMM’s truth condition is internal to the ledger. Can we extend the architecture to incorporate verifiable external facts while keeping the same replayability and auditability guarantees?
- **Embodiment and environment coupling:** How would PMM behave when coupled to simulated or real environments (e.g., robots, multi‑agent worlds)? What additional event kinds and projections are needed to capture embodied state?
- **Long‑range identity drift:** Over very long runs or across many sessions, how do identity, commitments, and self‑descriptions drift? Can PMM be used to detect and characterize such drift in different model families?
- **Discovering hidden tendencies:** Can PMM‑style projections reveal latent behavioral patterns (e.g., systematic biases in commitments or reflections) that are not obvious from raw text alone?

These questions point toward a broader research program in **computational phenomenology and agent foundations**, with PMM serving as a concrete, testable substrate rather than an abstract thought experiment.

---

## Appendix B: Evaluation Metrics for PMM Behavior

To support systematic evaluation of PMM‑based agents, we outline a set of quantitative and qualitative metrics.

### B.1 Quantitative Metrics

- **Reflection frequency:** Number of `reflection` events per $N$ ledger events (or per unit time). Useful for tracking how often the system engages in explicit self‑evaluation.
- **Stability score:** The `stability_score` reported by `stability_metrics` events, derived from policy change rates, commitment churn, reflection variance, and claim density.
- **Commitment churn:** Rate at which commitments are opened and closed:
  - $\text{churn} = \frac{\#\text{commitment\_open} + \#\text{commitment\_close}}{\#\text{events in window}}$.
- **Policy update rate:** Frequency of `policy_update` and `meta_policy_update` events, normalized by window size.
- **RSM deltas:** Magnitude of changes in RSM tendencies between snapshots (e.g., $|\Delta \text{determinism\_emphasis}|$, $|\Delta \text{instantiation\_capacity}|$).
- **Open commitment count:** Number of open commitments over time (from Mirror), indicating load and pending goals.

### B.2 Qualitative Metrics

- **Phenomenological richness:** A qualitative assessment of:
  - Diversity and specificity of self‑descriptions,
  - Nuance in discussing bias, stability, and identity,
  - Coherence of narratives across turns.
- **Cross‑model consistency score (proposed):**
  - Given the same ledger and projections, compare narratives from multiple LLMs.
  - Score consistency based on agreement about:
    - Identity labels and commitments,
    - Direction of RSM trends (e.g., “more deterministic” vs. “less deterministic”),
    - Interpretation of stability and learning dynamics.

These metrics position PMM as a reusable platform for empirical work on agent behavior, introspection, and phenomenology.

---

## Appendix C: Implementation Notes

This appendix summarizes key implementation details relevant for researchers and practitioners.

### C.1 Repository Structure

At a high level, the repository is organized as follows:

- `pmm/core/` — core abstractions:
  - `event_log.py` (SQLite ledger I/O),
  - `mirror.py`, `ledger_mirror.py` (replay and RSM support),
  - `rsm.py` (Recursive Self‑Model),
  - `meme_graph.py` (event graph),
  - `schemas.py`, `validators.py` (schemas and basic validation),
  - `ledger_metrics.py` (ledger‑level metrics).
- `pmm/runtime/` — runtime loop and autonomy:
  - `loop.py` (chat/runtime orchestrator),
  - `autonomy_kernel.py` (autonomy and learning logic),
  - `autonomy_supervisor.py` (slot‑based scheduler),
  - `reflection.py`, `reflection_synthesizer.py` (reflection composition),
  - `identity_summary.py` (summary generation),
  - `cli.py` (command‑line entry points).
- `pmm/context/` — contextual projections:
  - `context_graph.py`, `semantic_tagger.py`, `context_query.py`.
- `pmm/stability/`, `pmm/learning/`, `pmm/meta_learning/` — stability metrics, outcome tracking, policy evolution, and meta‑policy logic.
- `pmm/adapters/` — LLM adapters (OpenAI, Ollama, dummy).
- `file-exam/` — exported session artifacts (ledger JSON, readable logs, telemetry, SQL dumps).

### C.2 Invariants and Determinism Guarantees

Key invariants enforced by the implementation:

- **Append‑only events:** `EventLog` only appends; there are no in‑place updates or deletions.
- **Monotonic IDs:** Event IDs are strictly increasing integers.
- **Hash chain:** Each event stores `prev_hash` and `hash` consistent with a canonical serialization.
- **Pure projections:** Mirror, RSM, and other projections do not mutate the ledger and are deterministic functions of $E$.
- **Idempotent metrics and summaries:** Metrics and summary events are only appended when their serialized content changes, avoiding feedback loops.
 - **Concurrency-safe idempotent append:** via `INSERT OR IGNORE` plus `UNIQUE(hash)` on the `events` table.
 - **Hot-path elimination of `read_all()`:** interactive paths use bounded tails and live projections only.

These ensure that:

- Replaying the same ledger yields the same projections and summaries.
- External tools can validate integrity and recompute metrics without needing hidden state.

### C.3 Runtime Constraints and Considerations

- **Performance:** For larger ledgers, replay and projection updates may become costly; PMM mitigates this via:
  - Sliding windows (e.g., for stability metrics and RSM knowledge gaps),
  - Checkpoints (`summary_update`, `checkpoint_manifest`),
  - Bounded scans for idempotent metrics.
- **Adapter independence:** Adapters encapsulate provider‑specific details; swapping an LLM backend does not alter PMM’s core invariants.
- **Extensibility:** New projections, metrics, or event kinds can be added as long as:
  - They respect append‑only semantics,
  - Their state is deterministically derivable from the ledger.

These notes are intended to help researchers extend or re‑implement PMM while preserving its core guarantees.

---

## Citation

If you use PMM in your research, please cite:

```bibtex
@software{onanski2025pmm,
  author       = {Onanski, Scott},
  title        = {Persistent Mind Model: Deterministic Phenomenology in LLM Agents},
  year         = {2025},
  publisher    = {Zenodo},
  doi          = {10.5281/zenodo.17620317},
  url          = {https://doi.org/10.5281/zenodo.17620317}
}
```

Zenodo archive: [https://doi.org/10.5281/zenodo.17620317](https://zenodo.org/records/17620317)
