# Persistent Mind Model License — Version 1.0 (August 2025)

**Dual License — Non-Commercial / Commercial**  
© 2025 Scott O’Nanski  

SPDX-License-Identifier: PMM-1.0

---

## Preamble / Purpose  

This License governs the use, distribution, and derivative development of the **Persistent Mind Model (PMM)** — a model-agnostic, event-sourced artificial-intelligence runtime that maintains a **persistent, auditable self-model** through immutable ledger events.

Its intent is to   

1. Preserve PMM as **open prior art**, preventing enclosure by third-party patents.  
2. Permit **free non-commercial research, education, and experimentation.**  
3. Require **commercial users** to obtain a formal license.  
4. Protect the integrity, safety, and transparency of systems derived from this work.  

---

## 1. Definitions  

**“PMM”** — the Persistent Mind Model architecture, source code, database schema, and derivative systems including event-sourced ledgers, reflection loops, recursive self-models, and deterministic autonomy mechanisms.  
**“Derivative Work”** — any modification, extension, or system implementing or inspired by PMM principles.  
**“Non-Commercial Use”** — personal, academic, or research use that does not directly generate revenue or provide commercial advantage.  
**“Commercial Use”** — any integration, deployment, or service incorporating PMM or its derivatives for profit, compensation, or organizational benefit.  
**“Licensee”** — any individual or organization exercising rights under this License.  

---

## 2. Non-Commercial License  

Subject to compliance with this License, the Licensor grants the Licensee a  
**worldwide, royalty-free, non-exclusive, revocable right** to   

- Use and modify PMM for research, education, testing, or personal study.  
- Publish analyses, papers, or derivative prototypes referencing PMM architecture.  
- Redistribute unmodified copies of PMM source under this same License.  

### Conditions  

- **Attribution** must appear clearly in source and documentation:  

  > “Based on the Persistent Mind Model © 2025 Scott O’Nanski.”  

- **Derivative Works** must include this License in full.  
- Non-Commercial Use may *not* include integration into paid products, hosted services, or corporate systems without separate commercial permission.  

---

## 3. Commercial License  

Any Commercial Use requires a **signed commercial agreement** with the Licensor.  

Such agreement may include:  

- A one-time or recurring fee,  
- Attribution and co-branding terms,  
- Source-integrity and audit provisions,  
- Compliance with safety and transparency obligations.  

Commercial rights are **not implied** by possession or publication of source code.  
Unauthorized commercial deployment constitutes copyright infringement.  

---

## 4. Attribution & Redistribution  

- All redistributions of PMM or Derivative Works must retain this License, author credit, and version number.  
- Public presentations, publications, or academic references shall cite the PMM as:  

  > O’Nanski, S. (2025). *Persistent Mind Model v1.0 — A Deterministic, Event-Sourced Runtime for Auditable Artificial Cognition.*  

- Removal of attribution, obfuscation of provenance, or false claims of authorship are expressly prohibited.  

---

## 5. Prior-Art Disclosure 

[https://zenodo.org/records/17567446](https://zenodo.org/records/17567446)

The following constitutes a **formal disclosure of prior art**, establishing public record of the Persistent Mind Model as an original architecture for deterministic, self-referential AI systems.  

>  The Persistent Mind Model (PMM) is a portable, provider-neutral runtime for deterministic, self-referential artificial systems. It implements a cryptographically-chained event ledger recording every observation, reflection, and policy update. From this immutable log, the system reconstructs its self-model and identity trajectory over time. 
> Every reflection and decision is recorded as a cryptographically chained event, creating an  
> immutable ledger that serves as the system’s memory, audit trail, and identity.   
> The ledger records both each commitment *and the reasoning behind it*, enabling full reconstruction of the agent’s cognitive lineage and preventing infinite regress by verifying the **chain of reasoning** itself.  

This disclosure also covers any system that maintains AI identity, memory, or agency through append-only cryptographic event logs, hash-chained reasoning traces, or commitment-based self-model evolution.

### Core Architectural Innovations  

**1 — Cryptographic Reasoning Ledger**  
An append-only, hash-linked ledger that stores not only events but their logical justifications. Guarantees deterministic replay and permanent auditability of an AI’s thought process.  

**2 — Recursive Self-Model (RSM)**  
A self-referential identity engine that derives behavioral tendencies and self-metrics (e.g., `determinism_emphasis`, `uniqueness_emphasis`, `instantiation_capacity`) from ledger history. Defines identity as the evolving sum of recorded commitments and reflections, producing observable artificial psychology.  

**3 — Deterministic Autonomy Loop**  
A closed control cycle executing internal “ticks” that generate reflections and summaries without external input. Each tick reads the ledger, updates commitments, and logs its reasoning, yielding reproducible self-directed behavior and verifiable introspection.  

**4 — Truth-Handling Mechanisms**  
PMM distinguishes *truth as correspondence* (facts grounded in logged evidence) from *truth as coherence* (internal logical consistency). Coherence metrics (e.g., `coherence_check` events) inform policy and stability, but the authoritative record is the hash-chained ledger of events.  

**5 — Commitment and Identity Ratchet**  
Each commitment becomes a permanent identity element until explicitly closed. Revisions append new events without deletion, ensuring monotonic identity evolution and forensic traceability.  

**6 — Contradiction as Boundary Signal**  
Contradictory reflections are retained as boundary data, prompting automatic premise re-evaluation rather than erasure, forming a built-in error-diagnostic mechanism.  

**7 — Entity-Space Consistency Rule**  
Formally `Entity(x) ⇒ ∃e (kind(e)=x.kind ∧ e ∈ E)` — every recognized concept must map to a ledgered entity within its knowledge space, creating a mathematically defined feedback loop for recursive self-representation.  

### Collective Novelty Claim  

Together, these mechanisms form a **unified, ledger-based cognitive substrate** where reasoning, memory, and identity are one object — a verifiable chain of self-authored events. This architecture diverges from conventional neural or symbolic systems by treating the ledger itself as the mind, producing transparent, auditable, and reproducible artificial cognition.  

---

## 6. Patent Grant for Non-Commercial Licensees

Licensor covenants not to assert any patent claims against Non-Commercial Licensees for implementations compliant with this License. This covenant applies only to Non-Commercial Use as defined in Section 1 and does not extend to Commercial Use, for which separate agreements are required.

---

## 7. Limitations & Warranty Disclaimer  

PMM is provided “as is” without warranty of any kind, express or implied, including but not limited to merchantability, fitness for a particular purpose, or non-infringement. The Licensor shall not be liable for any claim, damages, or liability arising from use or inability to use PMM, whether in contract, tort, or otherwise.

---

## 8. Contributor License and Pull Requests

Contributions (including pull requests, patches, or other code submissions) are only accepted from contributors who have agreed to the project’s Contributor License Agreement (CLA). A link to the current individual and entity CLA is provided in the project documentation and/or repository contribution guidelines. By submitting a contribution under the CLA, the contributor grants the Licensor and Licensees the rights necessary to use, modify, and distribute the contribution under this License, while preserving the project’s defensive IP posture.

---

## 9. Acceptance & Jurisdiction

Use of PMM in any form constitutes acceptance of this License. All disputes shall be governed by the laws of Canada, under exclusive jurisdiction of its courts. The Licensor reserves the right to amend this License for future versions; existing Licensees retain rights under the version accepted at time of acquisition.

---
### End of License  

**Persistent Mind Model License v1.0 (August 2025)**  
**Dual License Structure / Expanded Prior-Art Disclosure Edition**  
© 2025 Scott O’Nanski — All Rights Reserved
