# The Battle of the Water Futures 🚰
## Designing the next generation of urban water systems

### Coming soon! 🔜

The highly anticipated 'Battle of the Water Networks' is back with a new challenge for the water community.
This competition will be hosted at the **4th International Joint Conference on Water Distribution Systems Analysis and Computing and Control in the Water Industry** (WDSA/CCWI 2026), taking place in Paphos, Cyprus, from May 18-21, 2026.

---

This competition embodies the core mission of Water-Futures and the theme for WDSA/CCWI 2026: **"Designing the next generation of urban water (and wastewater) systems."**

The objective is to **design and operate** a water distribution system over a long-term horizon **under deep uncertainty**, with interventions applied **in stages**.
For the first time, this challenge features a staged-design approach, unobservable and unknown uncertainties, and incorporates elements of policymaking and artificial intelligence.
The solutions will be assessed using a transparent and inspectable **open-source evaluation framework**.

## Participation rules 🚷

The competition is organized as an __invited session__ at the WDSA/CCWI 2026 conference.
The process and timeline for the battle are __independent of the standard conference submission workflow__.

> There is no requirement to also submit a regular conference paper to participate in the competition.

Keep in mind that:
- Participants may submit a solution individually or as part of a team, but each person can only be included in one team. 
- If your team submits a solution, at least one team member must register for the conference and present your work at the event.
- Each team is required to submit a short paper (4–6 pages) describing the methodology used.

More information about the conference and the regular paper submission are available on the [conference website](https://www.wdsa-ccwi2026.ucy.ac.cy/).

## Important dates 🗓️
- **1st September 2025** Competition announcement. Website launch. 

> Subscribe for updates and let us know if you are interested in participating!

**Stage 1**
- **24th November 2025** Competition begins: Instructions and first batch of data available.
- **19th December 2025** ___Abstract submission deadline___
- **9th January 2026** _Abstract acceptance notifications_
- **27th February 2026** First stage solution submission deadline.

**Stage 2**
- __2nd March 2026__ Second batch of data available.
- **20th March 2026** Second stage solution submission deadline.

**Stage 3**
- __23rd March 2026__ Third batch of data available. 
- **10th April 2026** Final deadline for submission of:
    - Third stage solution.
    - ___Short paper___.

- __18th May 2026__. Conference starts! 🎉

## Stay updated 📣

**Want to be notified when the competition launches?**

Send an email to: `battlewaterfutures@kwrwater.nl` with the subject "Competition Updates".

We'll share the calendar with you and keep you informed as soon as:
* Competition guidelines are published.
* Evaluation modules are released.
* Submission deadlines are approaching.

**Do you have questions?**

Send us an email or open a question on the [Q&A section of the GitHub repository](https://github.com/WaterFutures/water-futures-battle/discussions).


---

*This competition is organized by the Water-Futures team. More details about the organising commitee are coming soon!*

**⭐ Star this repository to stay up-to-date!**

---

*Explore our projects on [GitHub](https://github.com/WaterFutures) and learn more about our team and work on our [website](https://waterfutures.eu/).*

*Water-Futures has received funding from the European Research Council (ERC) under the European Union’s Horizon 2020 research and innovation program (Grant Agreement No. 951424).*
