From Coq.ssr Require Import ssreflect.
From stdpp Require Import gmap ssreflect.

Section more_stdpp.
Context `{Countable K} {V:Type}.

Lemma lookup_insert_case (X:gmap K V) x y i :
  <[y:=i]> X !! x = if (decide (y=x)) then Some i else X !! x.
Proof. case_decide; subst. rewrite lookup_insert //. rewrite lookup_insert_ne //. Qed.

Lemma lookup_total_insert_case `{Inhabited V} (X:gmap K V) x y i :
  <[y:=i]> X !!! x = if (decide (y=x)) then i else X !!! x.
Proof. rewrite !lookup_total_alt lookup_insert_case. by case_decide. Qed.

Lemma gmap_included_insert_notin (σ1 σ2:gmap K V) (l:K) (v:V) :
  l ∉ dom σ1 ->
  σ1 ⊆ σ2 ->
  σ1 ⊆ <[l:=v]>σ2.
Proof.
  intros ?? l'. destruct_decide (decide (l=l')).
  { subst. rewrite lookup_insert // not_elem_of_dom_1 //. }
  { rewrite !lookup_insert_ne //. }
Qed.

Lemma insert_insert_ne i j vi vj (m:gmap K V) :
  i ≠ j ->
  <[i:=vi]> (<[j:=vj]> m) = <[j:=vj]> (<[i:=vi]> m).
Proof.
  intros. apply map_eq. intros k.
  rewrite !lookup_insert_case.
  repeat case_decide; try done. congruence.
Qed.

Lemma insert_delete_ne k1 k2 v (e:gmap K V) :
  k1 ≠ k2 ->
  <[k1:=v]> (delete k2 e) = delete k2 (<[k1:=v]> e).
Proof.
  intros. apply map_eq. intros ?.
  rewrite !lookup_insert_case. case_decide; subst.
  { rewrite lookup_delete_ne // lookup_insert //. }
  { destruct_decide (decide (k2=i)).
    { subst. rewrite !lookup_delete //. }
    { rewrite !lookup_delete_ne // lookup_insert_ne //. } }
Qed.

End more_stdpp.

Section more_zip.

Lemma zip_app {A B:Type} (xs1 xs2:list A) (ys1 ys2:list B) :
  length xs1 = length ys1 ->
  zip (xs1 ++ xs2) (ys1 ++ ys2) = zip xs1 ys1 ++ zip xs2 ys2.
Proof.
  revert xs2 ys1 ys2. induction xs1; intros xs2 ys1 ys2 Hl.
  all:destruct ys1; try done.
  simpl. f_equal. apply IHxs1. simpl in Hl. lia.
Qed.

Lemma rev_zip {A B:Type} (xs:list A) (ys:list B) :
  length xs = length ys ->
  rev (zip xs ys) = zip (rev xs) (rev ys).
Proof.
  revert ys; induction xs. done.
  intros []; try done; simpl. intros.
  rewrite IHxs ?zip_app //.
  { rewrite !rev_length. lia. }
  { lia. }
Qed.

End more_zip.

Section more_rev.

Lemma fmap_rev {A B} (f:A -> B) xs :
  fmap f (rev xs) = rev (fmap f xs).
Proof.
  induction xs; first done.
  simpl. rewrite fmap_app IHxs //.
Qed.

End more_rev.
