From stdpp Require Import base sets gmap.

From iris.proofmode Require Import proofmode.
From iris.algebra Require Import gmap gset.

From dislog.utils Require Import more_stdpp more_iris.
From dislog.logic Require Import wp.

From dislog.types Require Import substmap.

Section utils.
Context `{interpGS true Σ}.

Lemma big_sepM2_binsert {A B} (i:binder) x1 x2 (m1:gmap string A) (m2:gmap string B) (Φ: _ -> _ -> iProp Σ) :
  Φ x1 x2 -∗
  ([∗ map] y1;y2 ∈ m1;m2, Φ y1 y2) -∗
  [∗ map] y1;y2 ∈ binsert i x1 m1;binsert i x2 m2, Φ y1 y2.
Proof.
  iIntros "? E". destruct i; first done.
  iDestruct (big_sepM2_lookup_iff with "[$]") as "%X".
  destruct (m1 !! s) as [e1|] eqn:E1.
  { assert (is_Some (m2 !! s)) as (e2&?) by naive_solver.
    rewrite -(insert_delete m1 s e1) // -(insert_delete m2 s e2) //.
    rewrite big_sepM2_insert. 2,3:rewrite lookup_delete //. simpl.
    rewrite !insert_insert.
    rewrite big_sepM2_insert. 2,3:rewrite lookup_delete //. simpl.
    iDestruct "E" as "(?&?)". iFrame. }
  { assert (m2 !! s = None).
    { destruct (m2 !! s) eqn:Hs; last done. exfalso.
      assert (is_Some (m1 !! s)) as (?&?); naive_solver. }
    iApply big_sepM2_insert. 1,2:done. iFrame. }
Qed.

Lemma big_sepM2_binserts_rev {A B} xs1 xs2 bs xs1' xs2' (m1:gmap string A) (m2:gmap string B) (Φ: _ -> _ -> iProp Σ) :
  length xs1 = length xs1' ->
  length xs2 = length xs2' ->
  xs1 = zip bs xs1' ->
  xs2 = zip bs xs2' ->
  ([∗ list] y1;y2 ∈ xs1';xs2', Φ y1 y2) -∗
  ([∗ map] y1;y2 ∈ m1;m2, Φ y1 y2) -∗
  [∗ map] y1;y2 ∈ binserts (rev xs1) m1;binserts (rev xs2) m2, Φ y1 y2.
Proof.
  iIntros (X1 X2 Heq1 Heq2) "E1".
  iInduction xs1 as [|] "IH" forall (xs2 bs xs1' xs2' m1 m2 X1 X2 Heq1 Heq2); iIntros "E2".
  { destruct xs1'; simpl in *; try congruence.
    iDestruct (big_sepL2_nil_inv_l with "[$]") as "->".
    destruct xs2; simpl in *; try congruence. done. }
  { destruct xs1'; simpl in *; try congruence.
    iDestruct (big_sepL2_cons_inv_l with "[$]") as "[% [% (->&E1&X1)]]".
    destruct xs2; simpl in *; try congruence. destruct bs; simpl in *; try congruence.
    inversion Heq1. subst. inversion Heq2. subst.
    rewrite !binserts_app.
    iApply ("IH" with "[%][%][%//][%//] X1"). 1,2:lia.
    iApply (big_sepM2_binsert with "[E1][$]"). done. }
Qed.


End utils.
