From stdpp Require Import base sets fin_sets.

From dislog.lang Require Import syntax semantics.
From dislog.newlang Require Import semantics.

(******************************************************************************)
(* Inversion lemmas for the det_step relation. *)

Ltac not_ctx K H := apply step_no_val in H; elim_ctx_sure.

Lemma invert_step_if σ α G t (b:bool) e1 e2 σ' α' T' e' :
  step G σ α (Leaf t) (If b e1 e2) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ e'=(if b then e1 else e2).
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b0; naive_solver.
Qed.

Lemma invert_step_let_val σ α G t x (v:val) e σ' α' T' e' :
  step G σ α (Leaf t) (Let x v e) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ e'=(subst' x v e).
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_fork σ α G t (v1 v2:val) σ' α' T' e' :
  step G σ α (Leaf t) (Par v1 v2) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ e'=(RunPar (Call v1 [Val VUnit]) (Call v2 [Val VUnit]))
  /\ exists v w, (t, v) ∈ G /\ (t, w) ∈ G /\ T' = Node t (Leaf v) (Leaf w).
Proof.
  intros E. inversion E; subst; elim_ctx.
  inversion H; subst.
  { exfalso. subst. inversion H4. all:by destruct b. }
  { naive_solver. }
  { destruct K; inversion H; subst; exfalso; eapply step_no_val; eauto. }
Qed.

Lemma invert_step_join σ α G T1 T2 (v1 v2:val) σ' α' T' e' t :
  step G σ α (Node t T1 T2) (RunPar v1 v2) σ' α' T' e' ->
  exists t1 t2 (l:loc),
    σ !! l = Some (SProd v1 v2) /\ α !! l = Some t /\ T1 = Leaf t1 /\ T2 = Leaf t2 /\
    (t1,t) ∈ G /\ (t2,t) ∈ G /\
    T' = Leaf t /\ e' = l /\ σ' = σ /\ α' = α.
Proof.
  inversion 1; subst; last first; elim_ctx.
  { exfalso. eapply step_no_val; eauto. }
  { exfalso. eapply step_no_val; eauto. }
  inversion H0. naive_solver.
Qed.

Lemma invert_step_par σ α G T1 e1 T2 e2 σ' α' T' e' t :
  ¬ (is_val e1 ∧ is_val e2) ->
  step G σ α (Node t T1 T2) (RunPar e1 e2) σ' α' T' e' ->
  (exists T1' e1', T'=(Node t T1' T2) /\ e'=RunPar e1' e2 /\ step G σ α T1 e1 σ' α' T1' e1') \/
  (exists T2' e2', T'=(Node t T1 T2') /\ e'=RunPar e1 e2' /\ step G σ α T2 e2 σ' α' T2' e2').
Proof.
  inversion 2; subst; elim_ctx; try naive_solver.
  inversion H1; subst. exfalso. naive_solver.
Qed.

Lemma invert_step_fill_item σ α G T K e σ' α' T' e'  :
  ¬ is_val e ->
  step σ α G T (fill_item K e) σ' α' T' e' ->
  exists e1, e' = fill_item K e1 /\
          step σ α G T e σ' α' T' e1.
Proof.
  inversion 2; subst; elim_ctx.
  { exfalso. eapply sched_step_no_ctx; eauto. }
  { apply fill_item_inj in H1; eauto using step_no_val. naive_solver. }
Qed.

Definition init_block (i:Z) (v:val) :=
  SBlock ((replicate (Z.to_nat i) v)).

Lemma invert_step_alloc σ α G t (i:Z) (v:val) σ' α' T' e' :
  step G σ α (Leaf t) (Alloc i v) σ' α' T' e' ->
  exists l, l ∉ dom σ /\ σ'= <[l:=init_block i v]> σ /\ α' = <[l:=t]> α /\ T' = Leaf t /\ e' = VLoc l /\ (0 < i)%Z.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_prod σ α G t (v1 v2:val) σ' α' T' e' :
  step G σ α (Leaf t) (Prod v1 v2) σ' α' T' e' ->
  exists l,  σ !! l = Some (SProd v1 v2) /\ α !! l = Some t /\ σ'= σ /\ α' = α /\ T' = Leaf t /\ e' = VLoc l.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_fst σ α G t (l:loc) σ' α' T' e' :
  step G σ α (Leaf t) (Fst l) σ' α' T' e' ->
  exists (v1 v2:val), σ !! l = Some (SProd v1 v2) /\ σ'=σ /\ α'=α /\ T'=Leaf t /\ e'=v1.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_snd σ α G t (l:loc) σ' α' T' e' :
  step G σ α (Leaf t) (Snd l) σ' α' T' e' ->
  exists (v1 v2:val), σ !! l = Some (SProd v1 v2) /\ σ'=σ /\ α'=α /\ T'=Leaf t /\ e'=v2.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_in σ α G t (b:bool) (v:val) σ' α' T' e' :
  step G σ α (Leaf t) (if b then InL v else InR v) σ' α' T' e' ->
   exists l, σ !! l = Some (if b then SInL v else SInR v) /\ α !! l = Some t /\ σ'= σ /\ α' = α /\ T' = Leaf t /\ e' = VLoc l.
Proof.
  inversion 1; last now (destruct b; not_ctx K H5). subst.
  inversion H0; subst; last (destruct b; naive_solver).
  inversion H5; subst; try (by destruct b).
  by destruct b,b0.
  destruct b,b0; try done; naive_solver.
Qed.

Lemma invert_step_case σ α G t (l:loc) xl el xr er σ' α' T' e' :
  step G σ α (Leaf t) (Case l xl el xr er) σ' α' T' e' ->
  exists (b:bool) (v:val),
    σ !! l = Some (if b then SInL v else SInR v) /\
    σ'=σ /\ T'=Leaf t /\ α' = α /\
    e' = if b then subst' xl v el else subst' xr v er.
Proof.
  inversion 1; last now not_ctx K H5. subst.
  inversion H0. subst.
  inversion H5; subst; try (by destruct b).
  exists b. destruct b; naive_solver.
Qed.

Lemma invert_step_closure σ α G t self args code σ' α' T' e' :
  step G σ α (Leaf t) (Clo (Lam self args code)) σ' α' T' e' ->
  exists l, σ !! l = Some (SClo self args code) /\ α !! l = Some t /\ σ'=σ /\ α'=α /\ T' = Leaf t /\ e' = VLoc l.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_load σ α G t (l:loc) (i:Z) σ' α' T' e' :
  step G σ α (Leaf t) (Load l i) σ' α' T' e' ->
  exists bs (v:val), σ !! l = Some (SBlock bs) /\ (0 ≤ i < Z.of_nat (length bs))%Z /\ bs !! (Z.to_nat i) = Some v /\ σ'=σ /\ α'=α /\ T'=Leaf t /\ e'=v.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_call σ α G t ts σ' α' T' e' self args body vs:
  ts = Val <$> vs ->
  step G σ α (Leaf t) (Call (VCode (Lam self args body)) ts) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ e'=(substs' (zip (self::args) (VCode (Lam self args body)::vs)) body).
Proof.
  intros Hts. inversion 1; subst.
  2:{ exfalso. destruct K; try naive_solver; simpl in *.
      all:inversion H0; subst; eapply step_no_val; eauto using must_be_val. }
  inversion H0; subst. inversion H5; subst.
  2,3:by destruct b.
  apply list_fmap_eq_inj in H13.
  2:{ intros ? ? E. injection E. easy. }
  naive_solver.
Qed.

Lemma invert_step_call_clo σ α G t (l:loc) ts σ' α' T' e' self args body vs:
  σ !! l = Some (SClo self args body) ->
  ts = Val <$> vs ->
  step G σ α (Leaf t) (Call l ts) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ e'=(substs' (zip (self::args) (VLoc l::vs)) body).
Proof.
  intros Hl Hts. inversion 1; subst.
  2:{ exfalso. destruct K; try naive_solver; simpl in *.
      all:inversion H0; subst; eapply step_no_val; eauto using must_be_val. }
  inversion H0; subst. inversion H5; subst.
  2,3:by destruct b.
  apply list_fmap_eq_inj in H9.
  2:{ intros ? ? E. injection E. easy. }
  naive_solver.
Qed.

Lemma invert_step_call_prim σ α G t σ' α' T' e' p (v1 v2:val):
  step G σ α (Leaf t) (CallPrim p v1 v2) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ exists v, e'=Val v /\ eval_call_prim p v1 v2 = Some v.
Proof.
  inversion 1; subst.
  2:{ exfalso. destruct K; try naive_solver; simpl in *.
      all:inversion H0; subst; eapply step_no_val; eauto using must_be_val. }
  inversion H0; subst. inversion H5; subst; try destruct b; naive_solver.
Qed.

Lemma invert_step_store σ α G t (l:loc) (i:Z) σ' α' T' e' (v:val) :
  step G σ α (Leaf t) (Store l i v) σ' α' T' e' ->
  exists bs, σ !! l = Some (SBlock bs) /\ (0 ≤ i < Z.of_nat (length bs))%Z  /\ σ'=<[l := SBlock (<[Z.to_nat i := v]> bs)]> σ /\ α'=α /\ T'=Leaf t /\ e'=VUnit.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_length σ α G t (l:loc)  σ' α' T' e' :
  step G σ α (Leaf t) (Length l) σ' α' T' e' ->
  exists bs, σ !! l = Some (SBlock bs) /\ σ'=σ /\ α'=α /\ T'=Leaf t /\ e'=(Z.of_nat (length bs)).
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_unfold_fold σ α G t (v:val) σ' α' T' e' :
  step G σ α (Leaf t) (Unfold (VFold v)) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ e'=v.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_fold σ α G t (v:val) σ' α' T' e' :
  step G σ α (Leaf t) (Fold v) σ' α' T' e' ->
  σ'=σ /\ α'=α /\ T'=(Leaf t) /\ e'=VFold v.
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.

Lemma invert_step_cas  σ α G t (l:loc) (i:Z) σ' α' T' e' (v1 v2:val) :
  step G σ α (Leaf t) (CAS l i v1 v2) σ' α' T' e' ->
  α'=α /\ T'=Leaf t /\ exists bs v1',
      (0 <= i < Z.of_nat (length bs))%Z /\ σ !! l = Some (SBlock bs) /\ bs !! (Z.to_nat i) = Some v1' /\ e' = Val (VBool (bool_decide (v1=v1'))) /\ σ' = (if bool_decide (v1=v1') then (insert l (SBlock (insert (Z.to_nat i) v2 bs)) σ) else σ) /\ (0 ≤ i < Z.of_nat (length bs))%Z .
Proof.
  inversion 1; subst; try now not_ctx K H5.
  inversion H0; subst. inversion H5; try destruct b; naive_solver.
Qed.
