From stdpp Require Import base numbers.

From dislog.lang Require Import syntax atomic.
From dislog.newlang Require Import semantics invert_step.


Lemma Atomic_correct σ α G t e σ' α' T' e' :
  Atomic e ->
  step G σ α (Leaf t) e σ' α' T' e' ->
  T' = Leaf t /\ exists v, e' = Val v.
Proof.
  inversion_clear 1; intros Hs.
  { apply invert_step_load in Hs. naive_solver. }
  { apply invert_step_store in Hs. naive_solver. }
  { apply invert_step_cas in Hs. naive_solver. }
  { apply invert_step_length in Hs. naive_solver. }
  { apply invert_step_call_prim in Hs. naive_solver. }
  { apply invert_step_alloc in Hs. naive_solver. }
Qed.

Lemma Atomic_no_val e :
  Atomic e ->
  to_val e = None.
Proof. by inversion 1. Qed.
