From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph.
From dislog.lang Require Import syntax reducible.
From dislog.newlang Require Import semantics invert_step.
From dislog.logic Require Import wpg interp.

Section wpg_store.
Context `{!interpGS he Σ}.

Lemma wpg_store E t (bs:list val) (l:loc) (i:Z) (v:val) :
  (0 <= i < length bs)%Z ->
  l ↦ bs -∗
  wpg E (Leaf t) (Store l i v) (fun w => ⌜w=VUnit⌝ ∗ l ↦ (<[Z.to_nat i:=v]> bs)).
Proof.
  iIntros.
  iApply wpg_unfold. wpg_intros. iDestruct "Hi" as "(%Hc&Hi)".
  iDestruct (interp_exploit_pointsto with "[$]") as "%Hl".
  intros_mod.
  assert (l ∈ dom σ) by by eapply elem_of_dom_2.
  iSplitR. { eauto using reducible_store1. }
  intros_post.
  eapply invert_step_store in Hstep.
  destruct Hstep as (?&(Hl'&?&?&?&?&?)); subst.
  rewrite Hl' in Hl. injection Hl. intros ->.
  iMod (interp_store with "[$]") as "(?&?)". iFrame.
  do 2 iModIntro. iMod "Hclose" as "_". iModIntro.
  iSplitR.
  { iPureIntro. intros. apply pureinv_leaf_val.
    { rewrite dom_insert_lookup_L //. eauto using pdom. }
    { done. } }
  iApply wpg_val. eauto.
Qed.

Lemma wpg_store_escape E t (bs:list val) (l:loc) (i:Z) (v:val) :
  he=true ->
  ¬ (0 <= i < length bs)%Z ->
  l ↦ bs -∗
  wpg E (Leaf t) (Store l i v) (fun _ => False).
Proof.
  iIntros.
  iApply wpg_unfold. wpg_intros. iDestruct "Hi" as "(%Hc&Hi)".
  iDestruct (interp_exploit_pointsto with "[$]") as "%Hl".
  intros_mod.
  assert (l ∈ dom σ) by by eapply elem_of_dom_2.
  iSplitR. { subst. eauto using reducible_store2. }
  intros_post. exfalso.
  eapply invert_step_store in Hstep.
  destruct Hstep as (?&(Hl'&?&?&?&?&?)); subst. congruence.
Qed.

End wpg_store.
