From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates gen_heap.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph more_iris.
From dislog.lang Require Import syntax semantics reducible invert_step.
From dislog.logic Require Import wpg interp all_abef wpg_alloc wpg_more wpg_call wps.

Section proof.
Context `{!interpGS he Σ}.

Lemma wpg_proj E (b:bool) t (l:loc) (v1 v2:val) :
  is_prod l v1 v2 -∗
  wpg E (Leaf t) (if b then Fst l else Snd l) (fun v => ⌜v=if b then v1 else v2⌝).
Proof.
  iIntros "#(Hl&[%t0 (X1&V1&?)])".

  rewrite wpg_unfold /wpg_pre.
  assert (to_val (if b then Fst l else Snd l) = None) as -> by by destruct b.

  wpg_intros; intros_mod.
  iDestruct "Hi" as "(%Hp&Hi)".
  iDestruct (interp_exploit_pointsto with "[$]") as "%".

  iSplitR.
  { iPureIntro. destruct b; eauto using reducible_fst, reducible_snd. }

  intros_post.
  iDestruct (interp_exploit_vclock _ _ _ _ v1 with "[$]") as "%". eauto using pdom.
  iDestruct (interp_exploit_vclock _ _ _ _ v2 with "[$]") as "%". eauto using pdom.

  do 2 iModIntro. iMod "Hclose". iModIntro.

  iDestruct (interp_use_allocated_at with "[$][$]") as "%Hl".
  { destruct Hp as [<- _]. by eapply elem_of_dom. }
  assert (reachable G t0 t).
  { destruct Hp as [_ Hc].
    apply rootsde_leaf_inv in Hc. specialize (Hc l).
    rewrite /abef Hl in Hc. apply Hc.
    destruct b; rewrite /locs /locs_expr; set_solver. }

  destruct b.
  { apply invert_step_fst in Hstep.
    destruct Hstep as (v1'&v2'&?&?&?&?&?); subst.
    assert (v1'=v1 /\ v2'=v2) as (->&->) by naive_solver.
    iFrame.
    iSplitR; last by iApply wpg_val.
    iPureIntro. eapply pureinv_leaf_val; eauto using pdom, vabef_pre_reachable. }
  { apply invert_step_snd in Hstep.
    destruct Hstep as (v1'&v2'&?&?&?&?&?); subst.
    assert (v1'=v1 /\ v2'=v2) as (->&->) by naive_solver.
    iFrame.
    iSplitR; last by iApply wpg_val.
    iPureIntro. eapply pureinv_leaf_val; eauto using pdom, vabef_pre_reachable. }
Qed.

Lemma wpg_fst E t (l:loc) (v1 v2:val) :
  is_prod l v1 v2 -∗
  wpg E (Leaf t) (Fst l) (fun v => ⌜v=v1⌝).
Proof. apply (wpg_proj _ true). Qed.

Lemma wpg_snd E t (l:loc) (v1 v2:val) :
  is_prod l v1 v2 -∗
  wpg E (Leaf t) (Snd l) (fun v => ⌜v=v2⌝).
Proof. apply (wpg_proj _ false). Qed.

End proof.
