From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates gen_heap.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph.
From dislog.lang Require Import syntax reducible.
From dislog.newlang Require Import semantics invert_step.
From dislog.logic Require Import wpg interp wpg_more.

Section wpg_par.
Context `{!interpGS he Σ}.

(* ------------------------------------------------------------------------ *)

Lemma reducible_join σ α G t T1 T2 (v1 v2:val):
  pureinv G α σ (Node t T1 T2) (RunPar v1 v2) ->
  reducible he σ α G (Node t T1 T2) (RunPar v1 v2).
Proof.
   intros [Hdom Hcomp].
   apply rootsde_join in Hcomp.
   destruct Hcomp as (?,(?,(?&?))); subst.
   eapply RedSched, lang.semantics_cycle.SchedJoin.
   2:apply is_fresh.
   2:{ rewrite Hdom. apply is_fresh. }
   all:reflexivity.
Qed.

(* A definitely strange lemma, allowing to give yourself a Plain assertion without consuming
   resources. I was not able to do without it. Maybe there is a simpler path. *)
Lemma give_plain E1 E2 Φ P (Ψ:iProp Σ) :
  Plain P ->
  (Φ ={E1,E2}=∗ P) -∗
   Φ ∗ (Φ ={E1,E2}=∗ P -∗ Ψ)
  ={E1,E2}=∗ Ψ.
Proof.
  iIntros (?) "E (H1&H2)".

  rewrite /fupd /bi_fupd_fupd /uPred_fupd. simpl.
  rewrite /uPred_fupd seal_eq /fancy_updates.uPred_fupd_def. simpl.
  iIntros "X".

  iAssert (◇ P)%I as "#P".
  { iMod ("E" with "H1 X") as "R". iMod "R" as "(?&?&?)". by iFrame. }
  iMod ("H2" with "[$][$]") as ">(?&?&Z)". iModIntro. iMod "P". iModIntro.
  iFrame. by iApply "Z".
Qed.

Lemma wpg_par_ctx E t T1 T2 (e1 e2:expr) Q1 Q2:
  wpg E T1 e1 Q1 -∗
  wpg E T2 e2 Q2 -∗
  wpg E (Node t T1 T2) (RunPar e1 e2)
  (fun v => ∃ (l:loc) (v1 v2:val),
       ⌜v=VLoc l⌝ ∗ is_prod l v1 v2 ∗
       (root T1) ≼ t ∗ (root T2) ≼ t ∗
       Q1 v1 ∗ Q2 v2).
Proof.
  iIntros "H1 H2".
  iLöb as "IH" forall (T1 T2 e1 e2). iApply wpg_unfold.
  wpg_intros. simpl.

  (* Are we going to join? *)
  destruct_decide (decide (is_val e1 /\ is_val e2)) as Hdec.
  {  intros_mod. iClear "IH".
    rewrite !is_val_true in Hdec.
    destruct Hdec as ((v1,->)&(v2,->)).
    iDestruct "Hi" as "(%Hcomp&Hi)".
    iSplitR.
    { eauto using reducible_join. }

    intros_post. apply invert_step_join in Hstep.
    destruct Hstep as (t1,(t2,(l,(?&?&?&?&?&?&?&?&?&?)))); subst.

    apply pureinv_par_inv in Hcomp. destruct Hcomp as (X1&X2).

    iMod (generate_vclock with "[$]") as "(Hi&#?)". apply X1.
    iMod (generate_vclock with "[$]") as "(Hi&#?)". apply X2.

    rewrite !wpg_unfold. do 2 iModIntro.
    iMod "Hclose" as "_". rewrite /wpg_pre. simpl.
    iMod "H1" as "(_&H1)". iMod "H2" as "(_&?)".

    rewrite /wpg_pre. simpl.

    iDestruct (interp_get_immut with "[$]") as "(?&?&?)". 2,3:done. done.
    iMod (alloc_prec t1 t with "[$]") as "(?&#?)". by apply edge_reachable.
    iMod (alloc_prec t2 t with "[$]") as "(?&#?)". by apply edge_reachable.
    iFrame.
    iSplitR. { iModIntro. destruct X1. eauto using pureinv_immut. }
    iModIntro. iIntros. iModIntro. iFrame "∗#".
    iSplitR; first done. iSplit.
    iApply (vclock_mon _ t1 with "[$][$]").
    iApply (vclock_mon _ t2 with "[$][$]"). }

  iDestruct "Hi" as "(%Hcomp&Hi)".
  destruct (pureinv_par_inv _ _ _ _ _ _ _ _ Hcomp) as (?&?).

  (* We use [give_plain] to give "reducible" in the post, without consuming [interp]. *)
  iApply (give_plain _ _ (wpg E T1 e1 Q1 ∗ interp σ α G)%I (⌜¬ is_val e1 -> reducible _ σ α G T1 e1⌝%I )).
  { iIntros "(H1&Hi)". rewrite !wpg_unfold.
    destruct_decide (decide (is_val e1)).
    { intros_mod. iPureIntro. naive_solver. }
    { rewrite /wpg_pre is_val_false1; last by naive_solver.
      iMod ("H1" with "[Hi]") as "X". by iFrame.
      iDestruct "X" as "(%&_)". iModIntro. iPureIntro.
      eauto. } }
  iFrame. iIntros "(H1&?)".

  iApply (give_plain _ _ (wpg E T2 e2 Q2 ∗ interp σ α G)%I (⌜¬ is_val e2 -> reducible  _ σ α G T2 e2⌝%I )).
  { iIntros "(H1&Hi)". rewrite !wpg_unfold.
    destruct_decide (decide (is_val e2)).
    { intros_mod. iPureIntro. naive_solver. }
    { rewrite /wpg_pre is_val_false1; last by naive_solver.
      iMod ("H1" with "[Hi]") as "X". by iFrame.
      iDestruct "X" as "(%&_)". iModIntro. iPureIntro. eauto. } }
  iFrame. iIntros "(H2&Hi)".

  intros_mod. iIntros (H1 H2). iSplitR.
  { iPureIntro. eapply RedPar; eauto. destruct (is_val e1), (is_val 2); naive_solver. }

  intros_post.
  apply invert_step_par in Hstep; last done.

  (* The step tells us where to reduce. *)
  destruct Hstep as [ (?&?&?&?&?) | (?&?&?&?&?) ]; subst.
  { rewrite {1}wpg_unfold /wpg_pre.
    rewrite is_val_false1; last by eapply step_no_val.
    iSpecialize  ("H1" with "[Hi]"). by iFrame.
    iMod "Hclose". iMod "H1" as "(_&H1)".
    iMod ("H1" with "[%//]") as "H1". do 2 iModIntro.
    iMod "H1" as "(%&?&?)". iModIntro.
    iFrame. iSplitR.
    { eauto using pureinv_par_l. }
    apply step_inv_root in H5. rewrite H5. iApply ("IH" with "[$][$]"). }
  { rewrite (wpg_unfold E T2) /wpg_pre.
    rewrite is_val_false1; last by eapply step_no_val.
    iSpecialize ("H2" with "[Hi]"). by iFrame.
    iMod "Hclose". iMod "H2" as "(_&H2)". iMod ("H2" with "[%//]") as "H2". do 2 iModIntro.
    iMod "H2" as "(%&?&?)". iModIntro.
    iFrame. iSplitR.
    { eauto using pureinv_par_r. }
    apply step_inv_root in H5. rewrite H5.
    iApply ("IH" with "[$][$]"). }
Qed.

Lemma wpg_fork E t (v1 v2:val) Q :
  ▷ (∀ t1 t2, t ≼ t1 ∗ t ≼ t2 -∗ wpg E (Node t (Leaf t1) (Leaf t2)) (RunPar (Call v1 [Val VUnit]) (Call v2 [Val VUnit]) ) Q) -∗
  wpg E (Leaf t) (Par v1 v2) Q.
Proof.
  iIntros "Hwp". iApply wpg_unfold.
  wpg_intros. intros_mod.

  iSplitR. { eauto using reducible_fork. }

  intros_post.
  apply invert_step_fork in Hstep. destruct Hstep as (?&?&?&(v,(w,(?&?&?)))).
  subst.
  iDestruct "Hi" as "(%&?)".

  iMod (alloc_prec t v with "[$]") as "(?&?)". apply edge_reachable. done.
  iMod (alloc_prec t w with "[$]") as "(?&?)". apply edge_reachable. done.
  do 2 iModIntro.
  iMod "Hclose" as "_". iFrame. iSplitR.
  { eauto using pureinv_fork. }
  iApply ("Hwp" $! v w with "[$]").
Qed.

(* This rule combines [wpg_fork] and [wpg_par_ctx], plus a monotonicity
   lemma. This strange wording is needed to allow the use of [t1] and
   [t2] as soon as possible in the proof. *)
Lemma wpg_par E t (v1 v2:val) Q:
  ▷ (∀ t1 t2, t ≼ t1 ∗ t ≼ t2 ={E}=∗
    (∃ Q1 Q2, wpg E (Leaf t1) (Call v1 [Val VUnit]) Q1 ∗ wpg E (Leaf t2) (Call v2 [Val VUnit]) Q2 ∗
     (∀ v, (∃ (l:loc) (v1 v2:val),
       ⌜v=VLoc l⌝ ∗ is_prod l v1 v2 ∗
       t1 ≼ t ∗ t2 ≼ t ∗
       Q1 v1 ∗ Q2 v2) -∗ Q v )))  -∗
  wpg E (Leaf t) (Par v1 v2) Q.
Proof.
  iIntros "Hwp".
  iApply wpg_fork. iModIntro. iIntros (t1 t2) "Hu".
  iApply fupd_wpg.
  iMod ("Hwp" $! t1 t2 with "Hu") as "[%Q1 [%Q2 (H1&H2&Hpost)]]".
  iModIntro. iApply (wpg_mono with "[-Hpost]").
  iApply (wpg_par_ctx with "H1 H2"). iIntros.
  iApply "Hpost". iFrame.
Qed.

End wpg_par.
