From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph.
From dislog.lang Require Import syntax semantics invert_step atomic reducible.
From dislog.newlang Require Import semantics invert_step atomic.
From dislog.logic Require Import wpg interp.

(* ------------------------------------------------------------------------ *)
(* This file defines important, non syntax-directed reasoning rules for
   dislog *)

Section wpg_more.
Context `{!interpGS he Σ}.

(* ------------------------------------------------------------------------ *)
(* [mementopre] *)

Lemma generate_clock l G α σ t e :
  l ∈ locs e ->
  pureinv G α σ (Leaf t) e ->
  interp σ α G ==∗
  interp σ α G ∗ l ◷ t.
Proof.
  intros ? [X1 X2]. iIntros "?".
  apply rootsde_leaf_inv in X2.
  assert (abef G α t l) by eauto.
  iMod (interp_insert_abef with "[$]") as "(Hi&?)". eauto.
  by iFrame.
Qed.

Lemma mementopre l E t e Q :
  ¬ is_val e ->
  l ∈ locs e ->
  (l ◷ t -∗ wpg E (Leaf t) e Q) -∗
  wpg E (Leaf t) e Q.
Proof.
  iIntros (Hne ?) "HP".
  rewrite !wpg_unfold /wpg_pre.
  apply is_val_false in Hne. rewrite Hne.
  wpg_intros. iDestruct "Hi" as "(%Hcomp&?)".
  iMod (generate_clock with "[$]") as "(Hi&?)".
  1,2:done.
  iApply ("HP" with "[$][Hi]"). by iFrame.
Qed.

Lemma vmementopre v E t e Q :
  ¬ is_val e ->
  locs v ⊆ locs e ->
  (v ◷? t -∗ wpg E (Leaf t) e Q) -∗
  wpg E (Leaf t) e Q.
Proof.
  iIntros (? Hlv) "HP".
  destruct_decide (decide (is_loc v)) as Hv.
  { iInduction v as [] "IH"; try done.
    { iApply (mementopre with "[$]"). done.
      rewrite /locs /location_val /locs_val in Hlv. rewrite /locs. set_solver. }
    { simpl. iApply "IH"; try done. } }
  { iApply "HP". induction v; naive_solver. }
Qed.

Definition all_abef_set t g : iProp Σ :=
  [∗ set] l ∈ g, l ◷ t.

Lemma mementopre_iterated E t e Q :
  ¬ is_val e ->
  (all_abef_set t (locs e) -∗ wpg E (Leaf t) e Q) -∗
  wpg E (Leaf t) e Q.
Proof.
  iIntros (?) "E".
  remember (locs e) as g.
  assert (g ⊆ locs e) by set_solver. clear Heqg.
  iInduction g as [|l] "IH" using set_ind_L.
  { iApply "E". by iApply big_sepS_empty. }
  { iApply (mementopre l). done. set_solver. iIntros.
    iApply ("IH" with "[%]"). set_solver.
    iIntros. iApply "E". iApply big_sepS_union. set_solver.
    rewrite big_sepS_singleton. iFrame "#". }
Qed.

Lemma exploit_all_abef_set G α σ t X :
  dom σ = dom α ->
  all_abef_set t X ∗ interp σ α G -∗
  ⌜all_abef G α t X⌝.
Proof.
  iIntros (?) "(HS&?)". rewrite /all_abef_set.
  iApply big_sepS_pure_1. rewrite !big_sepS_forall. iIntros.
  iSpecialize ("HS" with "[%//]").
  iApply interp_exploit_clock; eauto.
Qed.

(* ------------------------------------------------------------------------ *)
(* [mementopost] *)

Lemma pureinv_fold_inv G α σ t v :
  pureinv G α σ (Leaf t) (VFold v) ->
  pureinv G α σ (Leaf t) v.
Proof.
  intros [? X]. constructor. done.
  inversion X. constructor. set_solver. destruct K; inversion H.
Qed.

Lemma generate_vclock G α σ t (v:val) :
  pureinv G α σ (Leaf t) v ->
  interp σ α G ==∗ interp σ α G ∗ v ◷? t.
Proof.
  induction v; iIntros; try by iFrame.
  { iMod (generate_clock with "[$]") as "(?&?)"; last by iFrame.
    2:done. replace (locs (l:expr)) with ({[l]} :gset _); set_solver. }
  { simpl. iApply IHv; last done. eauto using pureinv_fold_inv. }
Qed.

Lemma mementopost E T e Q :
  ¬ is_val e ->
  wpg E T e (fun v => v ◷? (root T) -∗ Q v) -∗
  wpg E T e Q.
Proof.
  iIntros (He).
  iLöb as "IH" forall (T e He).
  iIntros "Hwp".

  rewrite !wpg_unfold /wpg_pre.
  rewrite is_val_false1; last by naive_solver.
  iIntros (???) "(%Hpure&Hi)". iMod ("Hwp" with "[Hi]") as "(?&Hwp)".
  by iFrame. iFrame.
  iModIntro. iIntros. iMod ("Hwp" with "[%//]") as "Hwp".
  do 2 iModIntro. iMod "Hwp" as "(%&?&Hwp)".
  replace (root T) with (root T') by (symmetry; eauto using step_inv_root).
  destruct_decide (decide (is_val e')) as Hv.
  { apply is_val_true in Hv. destruct Hv as (v&->).
    apply val_inv_final_tree in H; last done. destruct T'; try done.
    iMod (generate_vclock with "[$]") as "(?&?)". done.
    iFrame "%∗". iModIntro. rewrite !wpg_val_eq.
    iMod "Hwp" as "(?&HQ)". iFrame. by iApply ("HQ" with "[$]"). }
  iFrame "%∗". iModIntro. iApply ("IH" with "[%//][$]").
Qed.

(* An hyp-directed mementopost. *)
Lemma mementopost' E T e Q :
  ¬ is_val e ->
  wpg E T e Q -∗
  wpg E T e (fun v => v ◷? (root T) ∗ Q v).
Proof.
  iIntros. iApply mementopost. done.
  iApply (wpg_mono with "[$]").
  iIntros. by iFrame.
Qed.

(* ------------------------------------------------------------------------ *)
(* [wpg_bind_inv] *)

Local Lemma all_abef_invert T X σ α G :
  dom σ = dom α →
  ([∗ set] t ∈ T, [∗ set] l ∈ X,  l ◷ t) ∗ interp σ α G -∗
  ⌜set_Forall (λ t : timestamp, all_abef G α t X) T⌝.
Proof.
  iIntros (?) "(HS&?)".
  iApply big_sepS_pure_1. rewrite !big_sepS_forall. iIntros. iSpecialize ("HS" with "[%//]").
  iApply big_sepS_pure_1. rewrite !big_sepS_forall. iIntros. iSpecialize ("HS" with "[%//]").
  iApply interp_exploit_clock; eauto.
Qed.

Local Lemma all_abef_preserve1 t α G X σ:
  all_abef G α t X  ->
  interp σ α G ==∗ interp σ α G ∗ ([∗ set] l ∈ X,  l ◷ t).
Proof.
  iIntros (HT) "Hi".
  iInduction X as [|] "IH" using set_ind_L.
  { eauto. }
  { rewrite big_sepS_insert; last set_solver.
    iMod ("IH" with "[%][$]") as "(?&?)".
    { by eapply set_Forall_union_inv_2. }
    apply set_Forall_union_inv_1, set_Forall_singleton in HT.
    iMod (interp_insert_abef with "[$]") as "(?&?)". apply HT.
    by iFrame. }
Qed.

Local Lemma all_abef_preserve σ α G X L:
  set_Forall (λ t : timestamp, all_abef G α t X) L ->
  interp σ α G ==∗ interp σ α G ∗ ([∗ set] t ∈ L, [∗ set] l ∈ X, l ◷ t).
Proof.
  iIntros (HT) "Hi".
  iInduction L as [|] "IH" using set_ind_L.
  { eauto. }
  { rewrite big_sepS_insert; last set_solver.
    iMod ("IH" with "[%][$]") as "(?&?)".
    { by eapply set_Forall_union_inv_2. }
    apply set_Forall_union_inv_1, set_Forall_singleton in HT.
    iMod (all_abef_preserve1 with "[$]") as "(?&?)". apply HT.
    by iFrame. }
Qed.

Local Lemma wpg_bind_inv_pre E T e K Q :
  (is_val e -> is_leaf T) ->
  ([∗ set] t ∈ (frontier T), [∗ set] l ∈ locs K, l ◷ t) ∗ wpg E T (fill_item K e) Q -∗
  wpg E T e (fun v => wpg E (Leaf (root T)) (fill_item K v) Q ).
Proof.
  iIntros (HT) "(Hlocs&Hwp)".
  iLöb as "IH" forall (T e HT).
  iApply wpg_unfold.
  destruct (to_val e) eqn:He.
  { apply to_val_Some_inv in He. rewrite He. subst.
    destruct T; last (exfalso; naive_solver). iModIntro.
    by iFrame. }
  { rewrite wpg_unfold /wpg_pre He. wpg_intros.
    iDestruct "Hi" as "(%Hc&Hi)".
    iDestruct (all_abef_invert with "[$]") as "%".
    { by inversion Hc. }
    rewrite to_val_fill_item.
    iSpecialize ("Hwp" with "[Hi]").
    { iFrame. iPureIntro. eauto using pureinv_ctx. }
    iMod "Hwp" as "(%&Hwp)".
    iModIntro. iSplitR.
    { iPureIntro. eapply reducible_bind_inv; eauto. destruct e; naive_solver. }
    intros_post. pose proof (StepBind _ _ _ _ _ _ _ _ _ K Hstep).
    mod_all "Hwp" "(%&?&?)".

    assert (set_Forall (λ t : timestamp, all_abef G α' t (locs K)) (frontier T')).
    { intros t' Ht'.
      eapply all_abef_mon_amap.
      { eapply step_inv_amap; eauto. by inversion Hc. }
      eauto using step_inv_reach. }

    iMod (all_abef_preserve with "[$]") as "(?&HL)". eauto.
    iDestruct ("IH" with "[%]HL[$]") as "?".
    { eauto using val_inv_final_tree. }

    assert (root T = root T') as -> by eauto using step_inv_root.
    iFrame. iPureIntro. intros.
    apply pureinv_bind in H2; eauto using val_inv_final_tree.
    naive_solver. }
Qed.

(* [wpg_bind_inv] has an unusual precondition: the locations of the
   evaluation context should have been previously allocated. *)
Lemma wpg_bind_inv E t e K Q :
  ([∗ set] l ∈ locs K, l ◷ t) ∗ wpg E (Leaf t) (fill_item K e) Q -∗
  wpg E (Leaf t) e (fun v => wpg E (Leaf t) (fill_item K v) Q ).
Proof.
  iIntros "(?&?)".
  iApply (wpg_bind_inv_pre _ (Leaf t)). done.
  simpl. rewrite big_sepS_singleton. iFrame.
Qed.

End wpg_more.
