From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates gen_heap.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph more_iris.
From dislog.lang Require Import syntax semantics reducible invert_step.
From dislog.logic Require Import wpg interp all_abef wpg_alloc wpg_more wpg_call wps.

Section sum.

Context `{interpGS he Σ}.

Lemma wpg_case E t (l:loc) b (v:val) xl el xr er Q :
  is_sum l b v -∗
  wpg E (Leaf t) (if b then subst' xl v el else subst' xr v er) Q -∗
  wpg E (Leaf t) (Case l xl el xr er) Q.
Proof.
  iIntros "#(Hl&[%t0 (X&V)]) Hwp".

  iApply (vmementopre l). naive_solver. set_solver. iIntros "#[%t0' (X2&?)]".
  iDestruct (meta_agree with "X2 X") as "->".

  iApply wpg_unfold. wpg_intros. intros_mod.
  iDestruct "Hi" as "(%Hc&?)". inversion Hc.

  iDestruct (interp_exploit_pointsto with "[$]") as "%Hl".

  iSplit. eauto using reducible_case.

  intros_post.
  apply invert_step_case in Hstep.
  destruct Hstep as (b'&v'&?&?&?&?&?); subst.
  assert (b'=b /\ v'=v) as (->&->) by (destruct b,b'; naive_solver).

  iDestruct (interp_use_allocated_at with "[$][$]") as "%".
  { destruct Hc as [<- _]. by eapply elem_of_dom. }
  iDestruct (interp_prec_exploit with "[$][$]") as "%".

  iDestruct (interp_exploit_vclock _ _ _ _ v with "[$]") as "%". eauto using pdom.

  do 2 iModIntro. iMod "Hclose" as "_".
  iFrame. iPureIntro.

  eauto using pureinv_case, vabef_pre_reachable.
Qed.

End sum.
