From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph.
From dislog.lang Require Import syntax semantics reducible invert_step.
From dislog.logic Require Import wpg interp wpg_more.

Section wpg_call.
  Context `{!interpGS he Σ}.

Lemma use_allocated_at α l t :
  l ∈ dom α ->
  interp_amap α -∗
  allocated_at l t -∗
  ⌜α !! l = Some t⌝.
Proof.
  iIntros (Hd) "Hα Hal".
  apply elem_of_dom in Hd. destruct Hd as (v&Hd).
  iDestruct (big_sepM_lookup with "Hα") as "X". done.
  iDestruct (gen_heap.meta_agree with "Hal X") as "->".
  done.
Qed.

Lemma interp_use_allocated_at σ α G l t :
  l ∈ dom α ->
  interp σ α G -∗
  allocated_at l t -∗
  ⌜α !! l = Some t⌝.
Proof.
  iIntros (Hd) "(?&?&Hα&?) Hal".
  by iApply (use_allocated_at with "[$][$]").
Qed.

Lemma wpg_call E t self args body ts vs Q v :
  length args = length vs →
  ts = Val <$> vs ->
  func v self args body -∗
  ▷ (wpg E (Leaf t) (substs' (zip (self::args) (v::vs)) body) Q) -∗
  wpg E (Leaf t) (Call v ts) Q.
Proof.
  iIntros (? ?) "Hl Hwp".
  iApply (vmementopre v). naive_solver. set_solver. iIntros "#Hv".
  iApply wpg_unfold.
  wpg_intros. intros_mod. iDestruct "Hi" as "(%Hcomp&?)". simpl.
  destruct v; eauto.
  { iDestruct "Hl" as "(?&[% (#Ht0&#HX)])".
    iAssert (t0 ≼ t)%I as "#Hprec".
    { iDestruct "Hv" as "[% (Ht&?)]".
      iDestruct (gen_heap.meta_agree with "Ht0 Ht") as "->". done. }

    iAssert ([∗ set] l' ∈ locs (Lam self args body), l' ◷ t)%I with "[HX]" as "?".
    { iApply (big_sepS_impl with "[$]"). iModIntro. iIntros. iApply (clock_mon with "[$][$]"). }
    iDestruct (exploit_all_abef_set with "[$]") as "%Habef". eauto using pdom.

    iDestruct (interp_exploit_pointsto with "[$]") as "%Hl".
    iDestruct (interp_use_allocated_at with "[$][$]") as "%".
    { destruct Hcomp as [<-]. by eapply elem_of_dom. }

    iDestruct (interp_prec_exploit with "[$][$]") as "%".

    iSplitR.
    { iPureIntro.
      eapply reducible_call_clo; eauto. subst. rewrite fmap_length //. }
    intros_post. do 2 iModIntro. iMod "Hclose" as "_". iModIntro.
    eapply invert_step_call_clo in Hstep; eauto.
    destruct Hstep as (?&?&?&?). subst. iFrame.
    eauto using pureinv_call_clo. }
  { iDestruct "Hl" as "(%&%)". subst.
    iSplitR.
    { iPureIntro. eapply reducible_call; try done.
      rewrite map_length //. }
    intros_post. do 2 iModIntro. iMod "Hclose" as "_". iModIntro.

    eapply invert_step_call in Hstep; eauto.
    destruct Hstep as (?&?&?&?). subst. iFrame.
    eauto using pureinv_call. }
Qed.

End wpg_call.
