From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates gen_heap.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.utils Require Import graph.
From dislog.lang Require Import syntax reducible.
From dislog.newlang Require Import semantics invert_step.
From dislog.logic Require Import wpg interp all_abef.

Section wpg_alloc.
Context `{!interpGS he Σ}.

Lemma wpg_alloc E t (i:Z) (v:val) :
  (0 < i)%Z ->
  ⊢ wpg E (Leaf t) (Alloc i v)
      (fun w => ∃ l, ⌜w=VLoc l⌝ ∗ l ↦ (replicate (Z.to_nat i) v) ∗ meta_token l (⊤∖↑dislog_nm)).
Proof.
  iIntros.
  rewrite wpg_unfold. wpg_intros. intros_mod.
  iDestruct "Hi" as "(%Hc&?)". inversion Hc.

  iSplitR. { eauto using reducible_alloc1. }
  intros_post.
  apply invert_step_alloc in Hstep.
  destruct Hstep as (l&(?&?&?&?&?&?)); subst.
  iMod (interp_alloc _ _ _ l (init_block i v) t with "[$]") as "(?&?&?)". naive_solver.
  1,2:eauto. do 2 iModIntro.
  iMod "Hclose" as "_". iModIntro. iFrame.
  iSplitR.
  { eauto using pureinv_alloc. }
  iApply wpg_val. iExists _. iFrame. eauto.
Qed.

Lemma wpg_alloc_escape E t (i:Z) (v:val) :
  he=true ->
  ¬ (0 < i)%Z ->
  ⊢ wpg E (Leaf t) (Alloc i v) (fun _ => False).
Proof.
  iIntros.
  rewrite wpg_unfold. wpg_intros. intros_mod.
  iDestruct "Hi" as "(%Hc&?)". inversion Hc.

  iSplitR. { subst. eauto using reducible_alloc2. }
  intros_post. exfalso.
  apply invert_step_alloc in Hstep.
  destruct Hstep as (l&(?&?&?&?&?&?)); subst.
  congruence.
Qed.

End wpg_alloc.
