From iris.proofmode Require Import base proofmode.
From iris.base_logic.lib Require Export fancy_updates.
From iris.program_logic Require Import weakestpre.
From iris.algebra Require Import gset gmap frac.

From dislog.lang Require Import syntax semantics reducible disentangled.
From dislog.newlang Require Import simul.
From dislog Require Import wpg interp.

Section pre_adequacy.
Context `{iG:! interpGS he Σ}.

(******************************************************************************)
(* Adequacy *)

Definition adequate_pre σ α G T e Q : iProp Σ :=
  ⌜pureinv G α σ T e⌝ ∗ match to_val e with
  | Some v => ⌜is_leaf T⌝ ∗ Q v
  | None => ⌜reducible he σ α G T e⌝ end.

Lemma wpg_progress σ α G E T e Q :
  ⌜pureinv G α σ T e⌝ ∗ interp σ α G ∗ wpg E T e Q ={E, ∅}=∗
  adequate_pre σ α G T e Q.
Proof.
  iIntros "(%&Hi&Hwp)".
  rewrite wpg_unfold /wpg_pre /adequate_pre.

  destruct (to_val e) eqn:Ht.
  { destruct e; inversion Ht. subst v0.
    iMod "Hwp" as "(?&?)". iFrame.
    intros_mod. eauto. }

  iMod ("Hwp" with "[-]") as "[%Hred Hwp]". by iFrame. eauto.
Qed.

Lemma wpg_preservation n E e σ e' σ' Q G  α α' T T' :
  nsteps (simul.step G) n (σ,α,T,e) (σ',α',T',e') ->
  ⌜pureinv G α σ T e⌝ ∗ interp σ α G ∗ wpg E T e Q ={E,∅}=∗ |={∅}▷=>^n |={∅,E}=>
  ⌜pureinv G α' σ' T' e'⌝ ∗ interp σ' α' G ∗ wpg E T' e' Q.
Proof.
  revert σ α G T e Q.
  induction n; intros σ α G T e Q;
    inversion 1; subst;
    iIntros "(%&Hi&Hwp)".
  { iApply fupd_mask_intro. set_solver. iIntros "Hclose". iFrame.
    iMod "Hclose". eauto. }
  { rewrite wpg_unfold /wpg_pre. simpl. destruct y as (((?,?),?),?).
    assert (to_val e = None) as ->.
    { apply is_val_false. eapply step_no_val. eauto. }
    iMod ("Hwp" with "[Hi]") as "[_ Hwp]".
    { by iFrame. }
    iModIntro. iMod ("Hwp" with "[%//]") as "Hwp". do 2 iModIntro.
    iMod "Hwp" as "(%&?&Hwp)".
    iMod (IHn with "[-]") as "?". done. by iFrame. done. }
Qed.

Lemma wpg_adequacy_pre n E e σ e' σ' Q G α α' T T' :
  pureinv G α σ T e ->
  nsteps (simul.step G) n (σ,α,T,e) (σ',α',T',e') ->
  interp σ α G ∗ wpg E T e Q
  ={E,∅}=∗ |={∅}▷=>^n |={∅}=>
  adequate_pre σ' α' G T' e' Q.
Proof.
  iIntros (? Hsteps) "?".
  iMod (wpg_preservation with "[-]") as "?".
  { done. }
  { by iFrame. }
  iModIntro.
  iApply (step_fupdN_wand with "[$]").
  iIntros ">(?&?)". subst.
  iMod (wpg_progress with "[-]") as "?". iFrame.
  { iFrame. iPureIntro. eauto using rtc_nsteps_2. }
Qed.

End pre_adequacy.

Import Initialization.

(* ------------------------------------------------------------------------ *)
(* Final theorems *)

Definition step '(σ,α,G,T,e) '(σ',α',G',T',e') :=
  lang.semantics.step σ α G T e σ' α' G' T' e'.

Definition safe he σ α G T e :=
  (is_val e /\ is_leaf T) \/ reducible he σ α G T e.

Definition always_safe_and_disentangled (allow_oob:bool) (e:expr) :=
  forall t0 σ' α' G' T' e',
  rtc step (∅,∅,{[(t0,t0)]},(Leaf t0),e) (σ',α',G',T',e') ->
  safe allow_oob σ' α' G' T' e' /\ disentangled G' α' T' e'.

Lemma wpg_adequacy_open `{!interpPreG Σ} he σ α t e σ' α' G T' e' Q :
  dom σ = dom α ->
  pureinv G α σ (Leaf t) e ->
  rtc (simul.step G) (σ,α,(Leaf t),e) (σ',α',T',e') ->
  (∀ `{!interpGS he Σ}, ⊢ wpg ⊤ (Leaf t) e (fun v => ⌜Q v⌝)%I ) ->
  safe he σ' α' G T' e' /\ disentangled G α' T' e'.
Proof.
  intros ?? Hsteps Hwp.
  apply rtc_nsteps in Hsteps.
  destruct Hsteps as (n,Hsteps).

  eapply uPred.pure_soundness.
  apply (@step_fupdN_soundness_no_lc _ _ _ _ (S n) 0). iIntros.

  iMod (interp_init he σ α G) as "[%HinterpGS [%He Hi]]".
  1,2:eauto.

  iDestruct (Hwp HinterpGS) as "Hwp".

  iDestruct (@wpg_adequacy_pre _ _ _ n with "[Hi Hwp]") as "Hadequate".
  1,2:eauto.
  { iFrame. eauto. }

  rewrite -He.

  iApply (fupd_mono _ _ with "Hadequate").
  iIntros.

  rewrite step_fupdN_S_fupd. simpl. do 2 iModIntro.
  iModIntro. iStopProof. apply step_fupdN_mono. iIntros ">(%Hpure&Had) !>".
  rewrite /adequate_pre /safe. destruct (to_val e') eqn:He'.
  { iDestruct "Had" as "(%&_)". iPureIntro. split.
    { left. apply to_val_Some_inv in He'. subst.
      destruct T'; naive_solver. }
    { apply disentangled_is_rootsde; eauto using pcmp. } }
  { iDestruct "Had" as "%Hred". iPureIntro. split; first eauto.
    apply disentangled_is_rootsde; eauto using pcmp. }
Qed.

Lemma wpg_adequacy_gen he σ α t e σ' α' G T' e' Q :
  dom σ = dom α ->
  pureinv G α σ (Leaf t) e ->
  rtc (simul.step G) (σ,α,(Leaf t),e) (σ',α',T',e') ->
  (∀ `{!interpGS he Σ},
      ⊢ wpg ⊤ (Leaf t) e (fun v => ⌜Q v⌝)) ->
  safe he σ' α' G T' e' /\ disentangled G α' T' e'.
Proof.
  intros. eapply wpg_adequacy_open; eauto with typeclass_instances.
Qed.

(* The main theorem *)
Theorem wpg_adequacy (allow_oob:bool) (e:expr) (Q:val -> Prop) :
  locs e = ∅ ->
  (∀ `{!interpGS allow_oob Σ} t, ⊢ wpg ⊤ (Leaf t) e (fun v => ⌜Q v⌝)) ->
  always_safe_and_disentangled allow_oob e.
Proof.
  intros Ht Hwp. intros ?????? Hrtc.
  edestruct to_new as (?&?&Hsteps&X). 2:done. done.
  apply so6 in X.
  eapply wpg_adequacy_gen; eauto.
  eapply pureinv_init; eauto.
Qed.
