From iris.proofmode Require Import base proofmode.
From dislog.lang Require Import syntax reducible.
From dislog.newlang Require Import semantics simul.
From dislog.logic Require Import wpg interp wp wpg_adequacy.

Lemma wp_adequacy (allow_oob:bool) (e:expr) (Q:val -> Prop) :
  locs e = ∅ ->
  (∀ `{!interpGS allow_oob Σ} t, ⊢ wp ⊤ t e (fun v => ⌜Q v⌝)) ->
  always_safe_and_disentangled allow_oob e.
Proof.
  intros ? Hwp.
  eapply wpg_adequacy; eauto. intros ?? t.
  specialize (Hwp _ _ t).
  rewrite wp_eq in Hwp.
  iIntros. iApply wpg_mono. iApply Hwp.
  iIntros. rewrite post_val. by iFrame.
Qed.
