#!/bin/bash

count_lines () {
    num=0
    for line in $(find $1 -type f -name "*.v" -printf '%p\n' )
    do
	spec=$(coqwc -s $line | awk '{print $1;}')
	proof=$(coqwc -r $line | awk '{print $1;}')
	num=$(($num + $spec + $proof))
    done
    echo $num
}

echo "Number of lines as counted by coqwc, excluding comments. "
echo -n "Language: "
count_lines "src/lang/ src/newlang"

echo -n "Logic: "
count_lines "src/logic/ src/utils"

echo -n "Type system: "
count_lines "src/types"

echo -n "Examples: "
count_lines "src/examples"
