# IUGC2024 数据集说明文档

## 数据集结构

```
new/
├── train/                    # 训练集
│   ├── videos/              # 视频文件目录
│   ├── seg/                 # 分割标注目录
│   │   ├── seg_info.csv     # 分割标注信息文件
│   │   ├── landmark.json    # 标志点坐标和参数文件
│   │   └── [视频名]/        # 每个视频的分割标注目录
│   │       └── mask/        # 分割掩码目录
│   ├── cls/                 # 分类标注目录
│   │   └── class_label.csv  # 分类标签信息文件
│   └── train_info.csv       # 训练集信息文件
├── val/                     # 验证集
│   ├── videos/              # 视频文件目录
│   ├── seg/                 # 分割标注目录
│   │   ├── seg_info.csv     # 分割标注信息文件
│   │   ├── landmark.json    # 标志点坐标和参数文件
│   │   └── *.png            # 分割掩码图片文件
│   ├── cls/                 # 分类标注目录
│   │   └── cls_label.csv    # 分类标签信息文件
│   └── val_info.csv         # 验证集信息文件
└── test/                    # 测试集
    ├── videos/              # 视频文件目录
    ├── seg/                 # 分割标注目录
    │   ├── seg_info.csv     # 分割标注信息文件
    │   └── *.png            # 分割掩码图片文件
    ├── cls/                 # 分类标注目录
    │   └── cls_label.csv    # 分类标签信息文件
    └── test_info.csv        # 测试集信息文件
```

## CSV文件格式说明

### train_info.csv
包含以下列：
- `filename`: 视频文件名
- `pos`: 是否为标准面 (TRUE=标准面, FALSE=非标准面)
- `frame_count`: 视频总帧数
- `labeled_frame_count`: 已标注的帧数
- `labeled_frame_index`: 已标注帧的索引（逗号分隔的字符串）

**示例**:
```csv
filename,pos,frame_count,labeled_frame_count,labeled_frame_index
20190909T155747I1.avi,TRUE,80,9,"0,19,29,39,49,59,69,79,9"
20190726T095643_0.avi,FALSE,421,null,null
```

### val_info.csv / test_info.csv
包含以下列：
- `filename`: 视频文件名
- `SP_count`: SP（标准面）样本数量
- `NSP_count`: NSP（非标准面）样本数量
- `frame_count`: 视频总帧数
- `labeled_frame_count`: 已标注的帧数（通常为1）
- `labeled_frame_index`: 已标注帧的索引
- `SP_index`: SP（标准面）样本的帧索引列表
- `NSP_index`: NSP（非标准面）样本的帧索引列表

**示例**:
```csv
filename,SP_count,NSP_count,frame_count,labeled_frame_count,labeled_frame_index,SP_index,NSP_index
test_10_80.avi,72,9,81,1,80,"[9, 10, 11, ..., 80]","[0, 1, 2, ..., 8]"
```

### train/seg/seg_info.csv
包含以下列：
- `filename`: 视频文件名
- `frame_count`: 视频总帧数
- `labeled_frame_count`: 已标注的帧数
- `labeled_index`: 已标注帧的索引（逗号分隔的字符串）

**示例**:
```csv
filename,frame_count,labeled_frame_count,labeled_index
20190909T155747I1.avi,80,9,"0,19,29,39,49,59,69,79,9"
```

### val/seg/seg_info.csv / test/seg/seg_info.csv
包含以下列：
- `filename`: 视频文件名
- `frame_count`: 视频总帧数
- `labeled_frame_count`: 已标注的帧数（通常为1）
- `labeled_frame_index`: 已标注帧的索引

**示例**:
```csv
filename,frame_count,labeled_frame_count,labeled_frame_index
202012132137152159400I1.avi,20,1,6
```

### train/cls/class_label.csv
包含以下列：
- `filename`: 视频文件名
- `frame_count`: 视频总帧数
- `pos_index`: 标准面帧索引（"NONE"表示无标准面，"ALL"表示全部为标准面，或具体索引列表）
- `neg_index`: 非标准面帧索引（"ALL"表示全部为非标准面，或具体索引列表）

**示例**:
```csv
filename,frame_count,pos_index,neg_index
20190726T095643_0.avi,421,NONE,ALL
```

### val/cls/cls_label.csv / test/cls/cls_label.csv
格式与 `train/cls/class_label.csv` 相同。

## Landmark JSON文件格式说明

### train/seg/landmark.json / val/seg/landmark.json / test/seg/landmark.json
包含每个分割掩码图片的标志点坐标和测量参数。

**格式**:
- JSON文件是一个字典，键为掩码图片文件名
- 每个值是一个对象，包含：
  - `ps_points`: 两个PS标志点的数组，每个点的格式为 `[y, x]`（字符串）
  - `hsd_point`: HSD标志点，格式为 `[y, x]`（字符串）
  - `aop_tangency`: AOP切点，格式为 `[y, x]`（字符串）
  - `hsd`: HSD参数值（浮点数）
  - `aop`: AOP参数值（浮点数，单位为度）

**重要说明**:
- 坐标采用**先y后x**的顺序（即 `[y, x]`）
- 坐标原点位于图片的**左上角**
- JSON文件中所有坐标值都以字符串形式存储

**示例**:
```json
{
  "20190909T155747I1_0_6.png": {
    "ps_points": [
      ["69", "198"],
      ["84", "299"]
    ],
    "hsd_point": ["147", "294"],
    "aop_tangency": ["174", "339"],
    "hsd": 63.198101237299845,
    "aop": 122.41001622248665
  }
}
```

## 文件对应关系

### 1. 视频文件与分割标注的对应关系

#### 训练集 (train)
- **视频文件**: `train/videos/20190909T155747I1.avi`
- **分割标注信息**: `train/seg/seg_info.csv` 中 `filename` 列匹配的行
- **分割掩码图片**: 
  - 根据 `seg_info.csv` 中的 `labeled_index` 字段（如 `"0,19,29,39,49,59,69,79,9"`），每个帧对应一个掩码图片
  - 掩码图片路径: `train/seg/[视频名]/mask/[视频名]_[帧数]_6.png`
  - 示例: `train/seg/20190909T155747I1/mask/20190909T155747I1_0_6.png` 对应第0帧
  - 示例: `train/seg/20190909T155747I1/mask/20190909T155747I1_19_6.png` 对应第19帧
- **标志点数据**: 
  - 标志点坐标和参数存储在 `train/seg/landmark.json` 文件中
  - JSON文件中的键为掩码图片文件名（如 `"20190909T155747I1_0_6.png"`）
  - 每个条目包含PS点、HSD点、AOP切点以及计算得到的HSD/AOP值

#### 验证集 (val) / 测试集 (test)
- **视频文件**: `val/videos/202012132137152159400I1.avi` 或 `test/videos/test_10_80.avi`
- **分割标注信息**: `val/seg/seg_info.csv` 或 `test/seg/seg_info.csv` 中 `filename` 列匹配的行
- **分割掩码图片**: 
  - 根据 `seg_info.csv` 中的 `labeled_frame_index` 字段（如 `6`），只有一个掩码图片
  - 掩码图片路径: 验证集为 `val/seg/[视频名]_[帧数].png`，测试集为 `test/seg/[视频名].png`（视频名本身已包含帧索引信息）
  - 示例: `val/seg/202012132137152159400I1_6.png` 对应第6帧
  - 示例: `test/seg/test_10_80.png` 对应 `test_10_80.avi` 的第80帧
- **标志点数据**: 
  - 标志点坐标和参数存储在 `val/seg/landmark.json` 或 `test/seg/landmark.json` 文件中
  - JSON文件中的键为掩码图片文件名（如 `"202012132137152159400I1_6.png"` 或 `"test_10_80.png"`）
  - 每个条目包含PS点、HSD点、AOP切点以及计算得到的HSD/AOP值
