import { RolesSistema } from "@/interfaces/shared/RolesSistema";

export const EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA = 60;
export const EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA = 60;
export const EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_AUXILIARES = 60;
export const EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_AUXILIARES = 60;
export const EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_PROFESORES_SECUNDARIA = 60;
export const EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_PROFESORES_SECUNDARIA = 60;
export const EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_TUTORES = 60;
export const EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_TUTORES = 60;
export const EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO = 60;
export const EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO = 60;

export const EXTENSIONES_ENTRADA_MINUTOS_PARA_PERSONALES: Record<
  | RolesSistema.ProfesorPrimaria
  | RolesSistema.ProfesorSecundaria
  | RolesSistema.Auxiliar
  | RolesSistema.Tutor
  | RolesSistema.PersonalAdministrativo,
  number
> = {
  [RolesSistema.ProfesorPrimaria]:
    EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA,
  [RolesSistema.ProfesorSecundaria]:
    EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_PROFESORES_SECUNDARIA,
  [RolesSistema.Auxiliar]: EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_AUXILIARES,
  [RolesSistema.Tutor]: EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_TUTORES,
  [RolesSistema.PersonalAdministrativo]:
    EXTENSION_MINUTOS_ENTRADA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO,
};

export const EXTENSIONES_SALIDA_MINUTOS_PARA_PERSONALES: Record<
  | RolesSistema.ProfesorPrimaria
  | RolesSistema.ProfesorSecundaria
  | RolesSistema.Auxiliar
  | RolesSistema.Tutor
  | RolesSistema.PersonalAdministrativo,
  number
> = {
  [RolesSistema.ProfesorPrimaria]:
    EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_PROFESORES_PRIMARIA,
  [RolesSistema.ProfesorSecundaria]:
    EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_PROFESORES_SECUNDARIA,
  [RolesSistema.Auxiliar]: EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_AUXILIARES,
  [RolesSistema.Tutor]: EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_TUTORES,
  [RolesSistema.PersonalAdministrativo]:
    EXTENSION_MINUTOS_SALIDA_TOMA_ASISTENCIA_PERSONAL_ADMINISTRATIVO,
};

