import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const TelefonoIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`${className}`}
        viewBox="0 0 18 23"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M3.98168 0.0560818C3.38668 0.213581 2.44168 0.773581 1.93418 1.27233C1.33918 1.85858 0.840429 2.76858 0.639179 3.60858C0.411679 4.57983 0.507929 6.38233 0.849179 7.67733C1.47918 10.0661 2.73918 12.6561 4.76043 15.7186C8.45293 21.3098 12.1454 23.4623 15.2517 21.8173C15.9779 21.4323 16.9929 20.4611 17.2817 19.8661C17.4742 19.4636 17.5092 19.3061 17.4742 18.7986C17.4304 18.0373 17.3254 17.8886 15.8817 16.6286C14.5254 15.4473 14.2717 15.3336 13.1254 15.3861C12.2854 15.4211 11.5504 15.7098 10.8854 16.2436L10.5354 16.5236L9.61668 15.5698C7.69168 13.5923 6.23043 11.2911 5.29418 8.77983C4.79543 7.44983 4.79543 7.50233 5.42543 7.14358C6.37043 6.60983 7.16668 5.55108 7.30668 4.64983C7.35043 4.30858 6.99168 1.71858 6.80793 1.14108C6.71168 0.834831 6.29168 0.40608 5.86293 0.18733C5.51293 0.012331 4.46293 -0.0576687 3.98168 0.0560818Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default TelefonoIcon;
