import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const TardanzasIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 19 25"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M14.4762 0.857604C14.6411 1.11192 14.9417 1.92376 14.8932 1.97267C14.8641 2.00201 14.3696 1.35645 14.1272 0.974979C14.0884 0.906511 14.1175 0.808698 14.1853 0.740229C14.3017 0.652198 14.3599 0.671761 14.4762 0.857604Z"
          className="fill-current"
        />
        <path
          d="M12.8826 1.49682C13.3383 1.80982 13.9589 2.32823 13.9201 2.37713C13.8911 2.39669 13.7068 2.33801 13.4935 2.23041C13.2899 2.12282 12.9408 1.98588 12.708 1.91741C12.359 1.82938 12.2911 1.77069 12.3202 1.59463C12.359 1.33054 12.5723 1.29141 12.8826 1.49682Z"
          className="fill-current"
        />
        <path
          d="M11.9713 2.60023C12.6016 2.8252 12.8828 2.97192 12.8828 3.0893C12.8828 3.1382 12.7761 3.1382 12.6113 3.0893C12.398 3.01105 12.0489 2.97192 11.2053 2.90345C11.0598 2.88389 11.1859 2.45352 11.3313 2.43395C11.4089 2.42417 11.6998 2.49264 11.9713 2.60023Z"
          className="fill-current"
        />
        <path
          d="M15.8979 2.73955C16.8385 3.07211 17.4591 3.97199 17.4688 4.98924C17.4688 5.97714 17.0033 6.75964 16.1306 7.22914C15.5876 7.52258 14.5403 7.52258 13.9973 7.22914C12.7755 6.5738 12.3198 5.1653 12.921 3.93286C13.4446 2.84714 14.7536 2.32874 15.8979 2.73955Z"
          className="fill-current"
        />
        <path
          d="M10.8122 5.59304C11.074 5.79844 11.6267 6.2386 12.0437 6.58094C12.6061 7.03088 12.8873 7.19716 13.1006 7.19716C13.8667 7.19716 14.623 8.24376 14.3612 8.94801C14.2933 9.13385 14.2642 9.09472 14.1091 8.59588C13.9054 7.93076 13.6533 7.62754 13.2558 7.53951C12.7127 7.41235 12.1115 7.88185 12.1115 8.43938C12.1115 8.53719 12.354 9.35882 12.6449 10.2783L13.1685 11.9508L12.9842 12.4595C12.8776 12.7431 12.6352 13.5256 12.4412 14.2005C12.257 14.8754 12.0534 15.5112 11.9952 15.609C11.8594 15.8144 11.7624 15.6677 13.1394 17.3207C14.2739 18.6803 14.3418 18.7977 14.3418 19.2966C14.3418 19.8345 13.6048 24.1578 13.4691 24.4121C13.3333 24.6762 12.8097 24.999 12.5188 24.999C12.1309 24.999 11.6461 24.7251 11.4909 24.4219C11.2776 24.0111 11.297 23.7568 11.6655 21.5462L11.9855 19.5998L10.7831 18.1424C10.114 17.3403 9.56128 16.685 9.53219 16.685C9.51279 16.685 8.63038 17.1447 7.57343 17.712C5.59529 18.7684 5.2462 18.8857 4.77106 18.6119C4.49955 18.4554 1.48384 15.7362 1.24142 15.433C0.902037 14.9928 1.06688 14.1516 1.56142 13.8093C1.81354 13.6234 2.43413 13.6039 2.73473 13.7702C2.85109 13.8288 3.52017 14.3962 4.20864 15.0222L5.47893 16.1763L6.84617 15.4427L8.21342 14.7189L8.2813 14.3081C8.36857 13.7604 9.66794 11.0705 10.6279 9.47619L11.4037 8.19485L10.7346 7.63732L10.0655 7.08957L8.80493 7.79382C7.91282 8.29266 7.57343 8.52741 7.64131 8.59588C7.81585 8.77194 7.76737 9.00669 7.50556 9.25122C7.3698 9.37838 7.26314 9.5251 7.26314 9.58379C7.26314 9.64247 7.59283 9.9946 7.9904 10.3565C8.38796 10.7282 8.71766 11.0803 8.71766 11.1488C8.71766 11.3151 5.81831 14.3766 5.62438 14.4157C5.45953 14.4353 5.30438 14.2983 3.52987 12.5866C1.23173 10.3663 0.37841 9.51532 0.37841 9.42729C0.37841 9.30991 3.27775 6.24838 3.45229 6.17991C3.54926 6.14079 3.86926 6.38532 4.36379 6.8646L5.12014 7.61776L5.37226 7.30476C5.66317 6.96241 5.8571 6.92329 6.10922 7.15804C6.26437 7.30476 6.40982 7.23629 8.05827 6.31685C9.03765 5.7691 9.94915 5.2996 10.0849 5.28004C10.2691 5.24091 10.4534 5.31916 10.8122 5.59304ZM5.51771 7.53951C5.31408 7.75469 5.30438 7.8036 5.43044 7.91119C5.50802 7.97966 5.88619 8.34157 6.27406 8.71325L6.98193 9.38816L7.23405 9.13385C7.55404 8.81107 7.46677 8.66435 6.98193 8.73282C6.468 8.80129 6.09952 8.45894 6.09952 7.90141C6.09952 7.56885 5.97346 7.29498 5.80862 7.29498C5.76983 7.29498 5.64377 7.40257 5.51771 7.53951Z"
          className="fill-current"
        />
        <path
          d="M13.6412 7.92472C13.7478 8.06166 14.0872 8.95175 14.3878 9.91032C14.6981 10.8591 14.9599 11.6514 14.9696 11.6709C14.989 11.6905 15.7939 11.7394 16.7635 11.7883C18.4023 11.8666 18.5478 11.8861 18.7611 12.0915C19.0714 12.385 19.0811 12.9327 18.7805 13.2555L18.5672 13.4805L16.3854 13.4218C14.4751 13.3631 14.1648 13.3338 13.9515 13.1773C13.7575 13.0305 13.5539 12.5415 12.9527 10.7417C12.303 8.79525 12.2157 8.44313 12.303 8.20838C12.4485 7.83669 12.6715 7.68997 13.0982 7.68019C13.36 7.68019 13.4957 7.73888 13.6412 7.92472Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default TardanzasIcon;
