import { IconProps } from "@/interfaces/IconProps";

const TablaIcon = ({className,title}: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`aspect-auto ${className}`}
        viewBox="0 0 43 43"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M2.65319 0.383437C1.64681 0.839913 0.914894 1.5155 0.402553 2.46497L0 3.19533V21.5456C0 39.0926 0.0182979 39.9325 0.34766 40.535C0.823404 41.4297 1.51872 42.1418 2.37872 42.5983L3.11064 43H21.5H39.8894L40.6213 42.5983C41.4813 42.1418 42.1766 41.4297 42.6523 40.535C42.9817 39.9325 43 39.0926 43 21.5456V3.19533L42.5974 2.46497C42.0851 1.5155 41.3532 0.839913 40.3468 0.383437C39.5417 0.0182569 39.2489 -2.10293e-06 21.5 -2.10293e-06C3.75106 -2.10293e-06 3.4583 0.0182569 2.65319 0.383437ZM13.5953 13.3656L13.5404 16.3418L7.83149 16.3966L2.10426 16.4331V13.4204V10.4076H7.86808H13.6319L13.5953 13.3656ZM27.1723 13.4204V16.4331H21.5H15.8277V13.4204V10.4076H21.5H27.1723V13.4204ZM40.8957 13.4204V16.4331L35.1868 16.3966L29.4596 16.3418L29.4047 13.3656L29.3681 10.4076H35.1319H40.8957V13.4204ZM13.6319 21.5456V24.4671H7.86808H2.10426V21.5456V18.6242H7.86808H13.6319V21.5456ZM27.1723 21.5456V24.4671H21.5H15.8277V21.5456V18.6242H21.5H27.1723V21.5456ZM40.8957 21.5456V24.4671H35.1319H29.3681V21.5456V18.6242H35.1319H40.8957V21.5456ZM13.5953 29.7074L13.6319 32.6837H7.86808H2.10426V29.6709V26.6582L7.83149 26.6947L13.5404 26.7495L13.5953 29.7074ZM27.1723 29.6709V32.6837H21.5H15.8277V29.6709V26.6582H21.5H27.1723V29.6709ZM40.8957 29.6709V32.6837H35.1319H29.3681V29.7987C29.3681 28.2102 29.423 26.8408 29.4962 26.786C29.5511 26.713 32.1494 26.6582 35.26 26.6582H40.8957V29.6709ZM13.6319 37.8875V40.9002H8.74638C3.36681 40.9002 3.23872 40.8637 2.52511 39.8229C2.14085 39.2569 2.10426 38.983 2.10426 37.0476V34.8747H7.86808H13.6319V37.8875ZM27.1723 37.8875V40.9002H21.5H15.8277V37.8875V34.8747H21.5H27.1723V37.8875ZM40.8957 37.011C40.8957 39.4212 40.7494 39.8594 39.8162 40.4803C39.2123 40.9002 39.0843 40.9002 34.2902 40.9002H29.3681V37.8875V34.8747H35.1319H40.8957V37.011Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default TablaIcon;
