import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const SalidaIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`${className}`}
        viewBox="0 0 104 95"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M39.1255 1.39912C41.029 2.33062 41.3125 3.42412 41.3125 9.66112C41.3125 14.3591 41.2315 15.3311 40.705 15.3311C39.6925 15.3311 37.303 18.0446 37.06 19.5431C36.655 21.6896 37.141 23.1881 39.328 26.1446L41.3125 28.8986V34.8521V40.8461H36.493H31.6735L31.471 39.6311C30.985 37.2821 28.474 35.8646 26.287 36.6746C25.6795 36.9176 22.5205 39.1451 19.2805 41.6561C10.006 48.8246 10.0465 49.1081 21.3055 57.6941C25.396 60.8126 26.206 61.2986 27.6235 61.2986C28.96 61.2986 29.4865 61.0151 30.418 59.9621C31.066 59.2331 31.5925 58.3016 31.5925 57.8561C31.5925 57.0866 31.876 57.0461 36.4525 57.0461H41.3125V74.2586C41.3125 86.2466 41.191 91.7546 40.867 92.4431C39.814 94.7111 39.2875 94.7516 20.05 94.6301L2.3515 94.5086L1.177 93.1721L0.00249863 91.8761V47.7311V3.58612L1.177 2.29012L2.3515 0.953621L20.131 0.87262C35.4805 0.751122 38.032 0.832123 39.1255 1.39912Z"
          className="fill-current"
        />
        <path
          d="M66.4661 4.11331C68.7341 5.32831 70.5161 8.08231 70.7996 10.8768C71.0426 13.5903 69.4631 16.9518 67.1546 18.4503C65.2916 19.7058 61.6871 20.1513 59.4191 19.4223C56.7056 18.4908 53.8706 14.4813 53.8706 11.4843C53.8706 8.60881 56.3816 4.84231 59.0141 3.70831C61.0796 2.85781 64.4006 3.01981 66.4661 4.11331Z"
          className="fill-current"
        />
        <path
          d="M44.2701 17.2334C44.6751 17.3144 46.9026 19.9874 49.2516 23.1059C51.6006 26.2244 53.7471 28.6544 53.9901 28.5734C54.2736 28.4924 55.5696 28.0469 56.9061 27.6419C59.0526 26.9534 59.1741 26.8724 58.1616 26.6699L56.9871 26.4674L58.0806 25.1714C59.4171 23.5919 60.4296 23.2679 66.7476 22.4174C74.8476 21.2834 75.2526 21.3644 83.2716 26.0624C90.8046 30.4364 91.4931 30.9224 91.9386 32.1779C92.1411 32.6639 91.9791 37.3619 91.5741 42.8294C90.9261 51.9014 90.8046 52.6304 89.9541 53.5619C88.7796 54.8174 87.2406 55.1009 85.5801 54.4124C83.3931 53.4809 83.2311 52.6709 83.7576 44.5709C84.0411 40.6424 84.2436 36.9974 84.2436 36.5114C84.2436 35.9039 83.5956 35.2559 81.9351 34.2434C80.6391 33.4334 79.5456 32.8664 79.4646 32.9069C79.4241 32.9879 80.0316 37.3619 80.8011 42.6674C81.6111 48.0134 82.4211 55.2629 82.6641 58.8269C82.9071 62.4314 83.1501 65.7119 83.2311 66.1574C83.3931 66.8864 84.2841 67.1294 91.6146 68.3444C96.1506 69.1139 100.403 69.9644 101.051 70.2884C102.509 70.9364 103.684 72.7184 103.684 74.2574C103.684 76.6064 101.456 78.9149 99.2286 78.9149C97.6896 78.9149 77.2776 75.2699 76.5081 74.8244C74.7666 73.8929 74.4426 72.6779 73.8756 64.8614C73.5921 60.7304 73.2681 57.2879 73.2276 57.2474C73.1466 57.1664 71.9316 57.3284 70.5141 57.5714L67.9221 57.9764L65.3301 63.4844L62.6976 68.9924L61.5231 79.9274C60.7536 87.1364 60.1461 91.3079 59.7006 92.1179C57.9996 95.4389 53.0991 95.1959 51.6411 91.7129C51.1551 90.5789 51.2361 88.8779 52.2891 78.6719L53.5446 66.9674L56.8656 59.8394L60.2271 52.7114L59.1336 44.8544C58.5261 40.5209 58.1616 36.8354 58.3641 36.6329C58.5666 36.4304 59.5791 35.7419 60.6321 35.0939C62.8191 33.7574 62.2521 33.8789 56.7036 35.8229C52.4916 37.3214 51.6816 37.4429 50.3046 36.6734C49.1706 36.0254 39.4911 23.0249 39.1266 21.6479C38.4786 18.9749 41.4351 16.4234 44.2701 17.2334Z"
          className="fill-current"
        />
        <path
          d="M28.6773 39.3082C28.9608 39.5917 29.1633 40.5637 29.1633 41.5357V43.2772H36.7773C42.1638 43.2772 44.5533 43.4392 44.8773 43.7632C45.2013 44.0872 45.3633 45.8287 45.3633 49.0282C45.3633 53.3212 45.2823 53.8072 44.5938 54.2122C44.1078 54.4552 40.7463 54.6172 36.4938 54.6172H29.1633V56.4397C29.1633 58.7482 28.1103 59.5177 26.4093 58.4242C23.3313 56.4397 15.3933 49.9192 15.1503 49.2307C14.9883 48.7447 15.1908 48.1777 15.6363 47.6917C17.4588 45.9502 26.9763 38.8222 27.5433 38.8222C27.9078 38.8222 28.3938 39.0247 28.6773 39.3082Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default SalidaIcon;
