import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const ResponsablesIcon2 = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`text-inherit ${className}`}
        viewBox="0 0 27 19"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M6.42365 0.270829C4.87956 0.560368 3.63079 1.83112 3.36923 3.37533C3.14985 4.67021 3.82486 6.10986 5.00613 6.86588C6.2549 7.65407 7.86648 7.70232 9.13213 6.99456C9.58776 6.74524 10.305 6.02943 10.5328 5.60317C11.5369 3.72117 10.769 1.45311 8.81994 0.576453C8.00992 0.21453 7.25054 0.118017 6.42365 0.270829Z"
          className="fill-current"
        />
        <path
          d="M19.1239 0.270829C18.5923 0.351256 17.7823 0.729265 17.3098 1.11532C16.8458 1.50137 16.4323 2.10457 16.1961 2.76408C15.9261 3.52814 15.9936 4.59783 16.3564 5.3458C16.6517 5.95705 17.3183 6.6809 17.8751 6.99456C19.1408 7.70232 20.7524 7.65407 22.0011 6.86588C22.8533 6.31897 23.3765 5.54687 23.6043 4.48523C24.0093 2.58714 22.5833 0.640795 20.5161 0.262786C20.0014 0.174316 19.723 0.174316 19.1239 0.270829Z"
          className="fill-current"
        />
        <path
          d="M12.7804 5.32864C11.9704 5.56992 11.2279 6.35007 11.0592 7.1463C10.6963 8.81919 12.3164 10.3714 14.0292 9.99343C16.3411 9.48674 16.7546 6.53505 14.6536 5.51363C14.1726 5.28039 13.2529 5.19192 12.7804 5.32864Z"
          className="fill-current"
        />
        <path
          d="M3.40036 8.21637C1.61159 9.15737 0.405006 10.7659 0.0928139 12.6479C0.0421881 12.9375 0 13.9428 0 14.8758V16.5889H3.62818H7.25636V15.6479C7.25636 14.5138 7.3998 13.8945 7.8723 13.0098C8.28575 12.2297 9.31514 11.2083 10.083 10.7981C10.3614 10.6533 10.6061 10.5166 10.623 10.5086C10.6398 10.4925 10.5217 10.3397 10.3614 10.1627C10.0155 9.77666 9.66952 9.1252 9.53452 8.61046L9.43327 8.2405L9.08732 8.45765C7.79637 9.26997 5.97384 9.19759 4.35382 8.26463C4.08381 8.11181 3.856 7.98313 3.84756 7.98313C3.84756 7.98313 3.63662 8.08769 3.40036 8.21637Z"
          className="fill-current"
        />
        <path
          d="M22.9102 8.11181C22.5643 8.37722 21.5349 8.79545 20.9274 8.91609C20.2524 9.05282 19.358 9.02869 18.8011 8.86783C18.6323 8.81958 18.2948 8.65872 18.0586 8.50591C17.8139 8.3531 17.6114 8.22441 17.6029 8.22441C17.5861 8.22441 17.5354 8.41744 17.4764 8.65872C17.3667 9.11716 16.9279 9.88926 16.5651 10.2512C16.4386 10.3718 16.3542 10.4844 16.3795 10.5005C16.3964 10.5166 16.6917 10.6855 17.0376 10.8785C17.7633 11.2807 18.5648 12.0286 18.9783 12.6721C19.5014 13.5165 19.7545 14.3771 19.8052 15.5514L19.8558 16.5889H23.4333H27.0025V14.8758C27.0025 13.9428 26.9603 12.9375 26.9096 12.6479C26.589 10.7418 25.2727 9.0126 23.484 8.15203C23.0621 7.95096 23.1212 7.959 22.9102 8.11181Z"
          className="fill-current"
        />
        <path
          d="M12.2329 11.6585C11.0094 11.8515 9.76908 12.7041 9.26282 13.7094C8.86625 14.4815 8.77344 15.0284 8.77344 16.6852V18.1973H13.4985H18.2236V16.6048C18.2236 15.3019 18.1983 14.9158 18.0633 14.4815C17.6498 13.058 16.4011 11.9481 14.8992 11.6907C14.4182 11.6103 12.6801 11.5861 12.2329 11.6585Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default ResponsablesIcon2;
