import { IconProps } from "@/interfaces/IconProps";

const ResponsableIcon = ({ className, title }: IconProps) => {
  return (
    <div className="" title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 33 45"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M8.17755 0.186177C5.54025 1.16958 4.3557 3.82922 5.49555 6.26537C6.9036 9.30497 10.8372 9.68492 12.9828 6.98057C14.212 5.41607 13.9885 2.48823 12.5358 1.21428C11.3289 0.163827 9.4515 -0.283173 8.17755 0.186177Z"
          className="fill-current"
        />
        <path
          d="M4.35846 10.5118C3.06216 10.9812 2.07876 11.8528 1.40826 13.0597C0.871859 14.0878 0.782459 14.6019 0.357809 19.5636C-0.11154 24.9499 -0.11154 24.9723 0.313109 25.5534C0.871859 26.3133 1.89996 26.4474 2.61516 25.8663C3.10686 25.4863 3.15156 25.1734 3.41976 21.6645C3.84441 16.4122 4.00086 15.4288 4.40316 15.4288C4.69371 15.4288 4.76076 17.1721 4.85016 29.2858C4.91721 36.9072 5.05131 43.3216 5.16306 43.5451C5.43126 44.0815 6.03471 44.372 6.9287 44.372C7.53215 44.372 7.84505 44.2156 8.29205 43.6792L8.87315 42.9863V27.3637L9.49895 27.4308L10.1024 27.4978L10.3259 43.5227L10.8623 43.9474C11.5999 44.5508 12.695 44.4838 13.4326 43.8133L14.0136 43.2769V29.5764C14.0136 21.3292 14.103 15.7417 14.2371 15.5406C14.6618 14.8477 15.0641 15.8758 15.7793 19.4295C16.2933 22.1562 16.5839 23.1172 16.9638 23.5195C17.9249 24.5476 19.6011 23.8771 19.6011 22.4914C19.6011 21.1951 18.0143 14.289 17.4555 13.1268C16.8297 11.8528 15.8463 10.9588 14.5277 10.4895C13.3208 10.0648 5.52066 10.0872 4.35846 10.5118Z"
          className="fill-current"
        />
        <path
          d="M24.7378 19.586C22.0781 20.7035 21.6982 24.3912 24.0896 25.9781C25.1624 26.6933 26.8387 26.738 27.8891 26.1345C29.029 25.464 29.4983 24.6371 29.6101 23.2067C29.6771 22.1339 29.6101 21.7763 29.1631 21.1505C28.8949 20.7258 28.3808 20.1894 28.0456 19.9436C27.3527 19.4295 25.5647 19.2284 24.7378 19.586Z"
          className="fill-current"
        />
        <path
          d="M18.4879 24.7041C17.5715 25.6204 18.1303 27.0732 19.9629 28.7047C20.5217 29.1964 21.3263 29.7105 21.7509 29.8446L22.5108 30.1128V36.9072C22.5108 43.411 22.5332 43.7239 22.9578 44.1486C23.5613 44.752 24.4329 44.7073 25.0811 44.0368C25.6398 43.5004 25.6398 43.4334 25.6398 39.6786C25.6398 36.0355 25.6622 35.8791 26.0868 35.8791C26.5115 35.8791 26.5338 36.0355 26.5338 39.6562C26.5338 42.9864 26.5785 43.4781 26.9361 43.9474C27.5172 44.6403 28.6794 44.6403 29.2605 43.9474C29.6181 43.4781 29.6628 42.9193 29.6628 37.2648C29.6628 32.7501 29.7299 31.1632 29.9087 31.342C30.0428 31.4761 30.2663 32.3925 30.4227 33.3982C30.7133 35.4544 31.0932 36.0132 32.0096 35.7897C32.7918 35.5885 33.06 34.7616 32.8812 33.1077C32.6801 31.4091 32.2778 30.2022 31.5402 29.2411C30.5121 27.9001 30.1322 27.766 26.6456 27.6096C23.7401 27.4755 23.3601 27.4084 22.4438 26.872C21.885 26.5368 21.2145 25.911 20.9463 25.4863C20.1641 24.2124 19.2701 23.9218 18.4879 24.7041Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default ResponsableIcon;
