import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const ReportesIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M19.7369 0.124183C19.273 0.291984 18.9962 0.505548 18.6895 0.947932C18.4052 1.35218 18.2556 2.02338 18.3603 2.46577C18.3977 2.63357 18.4202 2.77086 18.4127 2.77849C18.4052 2.77849 17.8516 3.19799 17.1858 3.70902L15.9813 4.63192L15.6522 4.47175C15.2033 4.24293 14.4851 4.25056 13.9839 4.47937C13.0338 4.9065 12.525 5.95144 12.7794 6.92774L12.8916 7.34724L11.4852 8.7888C10.1311 10.1693 10.0712 10.2227 9.89915 10.1236C9.60738 9.96341 8.79942 10.0015 8.37299 10.1999C8.171 10.2914 7.94657 10.421 7.87924 10.4821C7.76702 10.5888 7.6548 10.5507 6.71966 10.0702L5.67977 9.53628L5.67229 9.24644C5.64237 8.40744 5.2309 7.75912 4.51271 7.39301C3.86933 7.06503 3.30825 7.06503 2.66487 7.39301C2.01401 7.72098 1.68483 8.17099 1.53521 8.91084C1.38559 9.6812 1.72224 10.5355 2.36562 11.016C2.64242 11.2295 3.23344 11.4279 3.58505 11.4279C3.95163 11.4279 4.56508 11.2143 4.81196 11.0007L5.03639 10.81L6.06879 11.3363L7.10119 11.8702L7.11616 12.2592C7.14608 13.0448 7.63984 13.7694 8.36551 14.105C8.77697 14.2957 9.60738 14.2957 10.0263 14.105C10.969 13.6703 11.5001 12.5796 11.2233 11.6338L11.1036 11.2372L12.5101 9.80323C13.8716 8.41506 13.924 8.3693 14.126 8.44557C14.4627 8.58287 15.2931 8.54473 15.6372 8.38456C16.505 7.98031 17.0586 6.95062 16.8716 6.08874L16.8043 5.79127L17.9414 4.92176C18.5623 4.44887 19.1159 4.02936 19.1683 3.99885C19.2207 3.96834 19.3853 3.99885 19.5424 4.07513C19.8865 4.24293 20.6571 4.30395 20.9937 4.18954C21.4201 4.04462 21.8989 3.69376 22.1308 3.35816C22.9313 2.1683 22.3702 0.505548 21.0236 0.101301C20.5448 -0.0436182 20.2082 -0.0359907 19.7369 0.124183Z"
          className="fill-current"
        />
        <path
          d="M18.6657 6.82936C18.305 7.04359 18.3125 6.82171 18.3125 14.97V22.5826H17.6361H16.9598V17.1581C16.9598 13.3939 16.9373 11.6648 16.8771 11.4964C16.7344 11.0756 16.5465 11.0297 14.8181 11.0297C13.0897 11.0297 12.9018 11.0756 12.759 11.4964C12.6989 11.6648 12.6763 13.3939 12.6763 17.1581V22.5826H12H11.3237V20.0272C11.3237 18.3593 11.2936 17.3953 11.241 17.2346C11.0982 16.8138 10.9103 16.7679 9.18193 16.7679C7.45351 16.7679 7.26564 16.8138 7.12286 17.2346C7.07026 17.3953 7.0402 18.3593 7.0402 20.0272V22.5826H6.36386H5.68753V18.5429C5.68753 14.6869 5.68001 14.5032 5.53723 14.2661C5.33433 13.9218 5.03373 13.8606 3.54579 13.8606C2.05785 13.8606 1.75726 13.9218 1.55436 14.2661C1.41157 14.5032 1.40406 14.6869 1.40406 18.5429V22.5826H0.990743C0.757782 22.5826 0.472218 22.6362 0.359495 22.6974C-0.046307 22.904 -0.12897 23.5466 0.216713 23.8527C0.359495 23.9904 0.780326 23.998 12 23.998C23.2197 23.998 23.6405 23.9904 23.7833 23.8527C24.129 23.5466 24.0463 22.904 23.6405 22.6974C23.5278 22.6362 23.2422 22.5826 23.0093 22.5826H22.5959V14.97C22.5959 6.77581 22.611 7.03594 22.2277 6.82171C22.0323 6.72225 18.846 6.72225 18.6657 6.82936Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default ReportesIcon;
