import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const RelojIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`aspect-square ${className}`}
        viewBox="0 0 22 22"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M9.05004 0.482878C4.90924 1.28565 1.70902 4.27883 0.596391 8.36149C0.21787 9.74913 0.21787 12.3409 0.596391 13.7286C1.62872 17.5475 4.49631 20.4145 8.31594 21.4466C9.70385 21.8251 12.2961 21.8251 13.6841 21.4466C17.5037 20.4145 20.3713 17.5475 21.4036 13.7286C21.7821 12.3409 21.7821 9.74913 21.4036 8.37296C20.3713 4.577 17.4922 1.67556 13.7414 0.666368C12.5714 0.345261 10.2085 0.253515 9.05004 0.482878ZM11.5047 4.72609C12.0323 5.00132 12.0897 5.28803 12.0897 7.9257V10.3569L13.9364 11.2744C14.9458 11.779 15.9093 12.318 16.0584 12.4671C16.6319 13.029 16.2764 14.107 15.4734 14.2676C14.9458 14.3708 10.3347 12.0542 10.0824 11.5611C9.94473 11.2859 9.91032 10.701 9.91032 8.32708C9.92179 5.23069 9.9562 5.02426 10.4953 4.72609C10.8509 4.53113 11.1147 4.53113 11.5047 4.72609Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default RelojIcon;
