import { IconProps } from "@/interfaces/IconProps";
import React from "react";

export const RankingsIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M11.1364 0.134989C10.6473 0.353995 10.2969 0.89421 10.2969 1.42713C10.2969 1.74103 10.6692 2.33235 10.9831 2.51486C11.6766 2.92367 12.5234 2.66816 12.8811 1.95274C13.0929 1.53663 13.1075 1.40522 12.998 1.00371C12.8446 0.448898 12.2533 -0.0037148 11.6839 -0.0037148C11.5452 -0.0037148 11.297 0.0619872 11.1364 0.134989Z"
          className="fill-current"
        />
        <path
          d="M4.88069 1.53684C4.21638 1.88725 3.98277 2.84357 4.41348 3.48599C4.9245 4.26712 6.05603 4.28172 6.63274 3.52249C6.81525 3.28889 6.83715 3.19398 6.83715 2.73407C6.83715 2.27416 6.81525 2.17926 6.63274 1.94565C6.22393 1.40543 5.46471 1.23023 4.88069 1.53684Z"
          className="fill-current"
        />
        <path
          d="M17.218 1.52954C17.072 1.60984 16.853 1.79235 16.7435 1.94565C16.561 2.17926 16.5391 2.27416 16.5391 2.73407C16.5391 3.19398 16.561 3.28889 16.7435 3.52249C17.3202 4.28172 18.4517 4.26712 18.9627 3.48599C19.2547 3.05528 19.2547 2.41286 18.9627 1.98215C18.5904 1.42003 17.8166 1.21563 17.218 1.52954Z"
          className="fill-current"
        />
        <path
          d="M9.76742 5.73388L8.86949 7.53703L8.00807 6.24489C7.54085 5.53677 7.14664 4.96006 7.13204 4.96006C7.11744 4.96006 6.95684 5.04036 6.78893 5.14256C6.61373 5.23746 6.32172 5.33967 6.13921 5.36887C5.95671 5.39807 5.7742 5.43457 5.7304 5.46377C5.6501 5.51487 6.85463 11.7419 7.00794 12.0194C7.05174 12.1143 7.15394 12.2165 7.23424 12.2603C7.42405 12.3625 15.9507 12.3625 16.1405 12.2603C16.2208 12.2165 16.323 12.1143 16.3668 12.0194C16.5201 11.7419 17.7246 5.51487 17.6443 5.46377C17.6005 5.43457 17.418 5.39807 17.2355 5.36887C17.053 5.33967 16.761 5.23746 16.5858 5.14256C16.4179 5.04036 16.2573 4.96006 16.2427 4.96006C16.2281 4.96006 15.8266 5.53677 15.3594 6.24489L14.5052 7.53703L13.6073 5.73388L12.7021 3.93073L12.4685 3.98913C12.3371 4.01833 11.9867 4.04753 11.6874 4.04753C11.3881 4.04753 11.0377 4.01833 10.9062 3.98913L10.6726 3.93073L9.76742 5.73388Z"
          className="fill-current"
        />
        <path
          d="M8.61311 13.831C8.51091 13.8894 8.38681 14.0281 8.33571 14.1376C8.27731 14.2909 8.2554 15.5101 8.27001 18.6638L8.29191 22.9855L8.45981 23.1534L8.62772 23.3213H11.6865H14.7453L14.9132 23.1534L15.0811 22.9855L15.103 18.6638C15.1176 15.5028 15.0957 14.2909 15.0373 14.1376C14.8694 13.7288 14.8037 13.7215 11.6719 13.7215C9.33584 13.7288 8.76642 13.7434 8.61311 13.831Z"
          className="fill-current"
        />
        <path
          d="M0.197106 16.722L0 16.9484L0.0219006 19.9706L0.0438012 22.9856L0.211706 23.1535L0.379611 23.3214L3.3946 23.3433L6.41688 23.3652L6.64319 23.1681L6.86949 22.9783V19.9195V16.8535L6.68699 16.6782L6.51178 16.4957H3.4457H0.386911L0.197106 16.722Z"
          className="fill-current"
        />
        <path
          d="M16.8942 19.2698C16.5219 19.4158 16.5 19.5472 16.5 21.3212V22.9783L16.7263 23.1681L16.9526 23.3652L19.9749 23.3433L22.9899 23.3214L23.1578 23.1535C23.3257 22.9929 23.3257 22.9637 23.3257 21.2774C23.3257 19.591 23.3257 19.5618 23.1578 19.4012L22.9899 19.2333L20.0187 19.2187C18.3835 19.2114 16.9745 19.2333 16.8942 19.2698Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};
