import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const QRIcon = ({className,title}:IconProps) => {
  return (
    <div title={title}>
      <svg
        className={`aspect-square  ${className}`}
        viewBox="0 0 39 39"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M3.01163 0.260496C1.52807 0.794577 0.474746 1.95175 0.148363 3.46498C0.0296787 3.93972 -0.014828 5.30459 0.0296787 7.11453C0.0741854 9.68109 0.103857 10.0816 0.385733 10.6899C0.845635 11.6691 1.54291 12.3812 2.49238 12.8559L3.33801 13.2713H6.67602C9.76182 13.2713 10.0734 13.2416 10.6965 12.9598C11.6756 12.4998 12.3877 11.8026 12.8625 10.8531L13.2778 10.0075V3.33146L12.8625 2.48583C12.3877 1.53636 11.6756 0.839084 10.6965 0.379181C10.0734 0.0973051 9.70247 0.067634 6.89855 0.0231272C4.19848 -0.00654392 3.67923 0.0231272 3.01163 0.260496ZM9.56895 3.1386C10.2811 3.46498 10.3849 3.89521 10.3849 6.66947C10.3849 10.4229 10.4294 10.3784 6.67602 10.3784C2.90778 10.3784 2.96712 10.4229 2.96712 6.63979C2.98196 3.89521 3.05614 3.53916 3.72374 3.16827C4.19848 2.90123 9.0052 2.88639 9.56895 3.1386Z"
          className="fill-current"
        />
        <path
          d="M5.94902 5.3936C4.65832 6.10571 5.20724 8.15302 6.67596 8.15302C7.43257 8.15302 8.15952 7.42608 8.15952 6.6843C8.15952 5.57163 6.92816 4.84469 5.94902 5.3936Z"
          className="fill-current"
        />
        <path
          d="M19.4939 0.497864C19.034 0.957767 18.9895 1.09129 18.9895 1.83307V2.66386H18.0994C17.0609 2.66386 16.4527 2.91606 16.2004 3.47982C15.9631 3.98422 15.9779 4.36995 16.2301 4.87436C16.512 5.40844 17.0461 5.63097 18.0994 5.63097H18.9895V8.30138H18.0994C16.1708 8.30138 16.0224 8.58325 16.0224 12.307V15.1554L16.4527 15.5856C16.7939 15.9269 17.0164 16.0159 17.506 16.0159C17.9956 16.0159 18.2181 15.9269 18.5593 15.5856L18.9895 15.1554V11.2685H19.8797C20.3544 11.2685 20.933 11.1943 21.1407 11.0905C21.9121 10.7344 21.9567 10.4822 21.9567 5.64581C21.9567 0.853918 21.9121 0.586878 21.2 0.201153C20.5324 -0.140066 20.0429 -0.0510521 19.4939 0.497864Z"
          className="fill-current"
        />
        <path
          d="M27.6387 0.260496C26.1551 0.794577 25.1018 1.95175 24.7754 3.46498C24.6567 3.93972 24.6122 5.30459 24.6567 7.11453C24.7012 9.68109 24.7309 10.0816 25.0128 10.6899C25.4727 11.6691 26.17 12.3812 27.1194 12.8559L27.9651 13.2713H31.3031C34.3889 13.2713 34.7004 13.2416 35.3235 12.9598C36.3027 12.4998 37.0148 11.8026 37.4895 10.8531L37.9049 10.0075V3.33146L37.4895 2.48583C37.0148 1.53636 36.3027 0.839084 35.3235 0.379181C34.7004 0.0973051 34.3295 0.067634 31.5256 0.0231272C28.8255 -0.00654392 28.3063 0.0231272 27.6387 0.260496ZM34.196 3.1386C34.9081 3.46498 35.012 3.89521 35.012 6.66947C35.012 10.4229 35.0565 10.3784 31.3031 10.3784C27.5348 10.3784 27.5942 10.4229 27.5942 6.63979C27.609 3.89521 27.6832 3.53916 28.3508 3.16827C28.8255 2.90123 33.6323 2.88639 34.196 3.1386Z"
          className="fill-current"
        />
        <path
          d="M30.5761 5.3936C29.2854 6.10571 29.8343 8.15302 31.303 8.15302C32.0596 8.15302 32.7866 7.42608 32.7866 6.6843C32.7866 5.57163 31.5552 4.84469 30.5761 5.3936Z"
          className="fill-current"
        />
        <path
          d="M1.083 16.0307C0.148356 16.2978 0 16.6983 0 18.9385V20.9413L0.430232 21.3715C0.77145 21.7127 0.993984 21.8018 1.48356 21.8018C1.97313 21.8018 2.19567 21.7127 2.53688 21.3715C2.92261 20.971 2.96712 20.8374 2.96712 19.9621V18.983H3.61988C3.97593 18.983 4.46551 18.9385 4.73255 18.894C6.33479 18.5676 6.33479 16.2829 4.73255 15.9565C4.05011 15.823 1.63191 15.8675 1.083 16.0307Z"
          className="fill-current"
        />
        <path
          d="M23.0402 16.0307C22.0611 16.3126 21.6457 17.4994 22.2539 18.2857C22.6842 18.8346 23.3814 18.983 25.5474 18.983H27.4316L27.5206 24.0568L27.936 24.4128C28.5442 24.9321 29.4047 24.9024 29.9833 24.3386C30.369 23.9381 30.4135 23.8046 30.4135 22.9293V21.9501H31.0663C32.6537 21.9501 33.3806 21.4605 33.3806 20.3924C33.3806 19.3242 32.6537 18.8346 31.0663 18.8346H30.4135V17.8852C30.4135 16.7577 30.102 16.2532 29.2563 16.0159C28.5887 15.8378 23.693 15.8378 23.0402 16.0307Z"
          className="fill-current"
        />
        <path
          d="M9.62835 16.446C9.24262 16.8466 9.19812 16.9801 9.19812 17.8406V18.8049L8.50084 18.9087C6.67607 19.1758 6.40903 21.3121 8.12995 21.8017C8.4415 21.8758 10.2959 21.95 12.3581 21.95H16.0225V22.6918C16.0225 23.5968 16.3044 24.205 16.8384 24.4424C17.3428 24.6798 17.7286 24.6649 18.233 24.4127C18.8561 24.0863 18.9896 23.5968 18.9896 21.6681C18.9896 18.9532 18.8116 18.8345 14.7466 18.8345H12.1949L12.1356 17.7812C12.0911 16.8466 12.0317 16.6834 11.6757 16.3718C11.0674 15.8526 10.1921 15.8823 9.62835 16.446Z"
          className="fill-current"
        />
        <path
          d="M35.4424 16.4461C34.5226 17.3659 35.1605 18.8346 36.4957 18.8346C36.9853 18.8346 37.2078 18.7456 37.549 18.4044C38.4688 17.4846 37.8309 16.0159 36.4957 16.0159C36.0061 16.0159 35.7836 16.1049 35.4424 16.4461Z"
          className="fill-current"
        />
        <path
          d="M22.3872 22.3803C21.957 22.8106 21.957 22.8402 21.957 24.4573V26.1041H21.4377C20.1174 26.1041 19.3756 27.2019 19.9394 28.3146C20.2509 28.908 20.7701 29.0712 22.3279 29.0712C24.8054 29.0712 24.9241 28.908 24.9241 25.3623V22.8106L24.4939 22.3803C24.1527 22.0391 23.9301 21.9501 23.4405 21.9501C22.951 21.9501 22.7284 22.0391 22.3872 22.3803Z"
          className="fill-current"
        />
        <path
          d="M35.4417 22.3803C35.0115 22.8106 35.0115 22.8402 35.0115 24.4573V26.1041H33.5279C31.896 26.1041 31.3767 26.2673 31.0652 26.8607C30.6646 27.6321 30.9465 28.5668 31.6734 28.8932C31.9257 29.0118 32.9048 29.0712 34.418 29.0712C38.0082 29.0712 37.9786 29.1009 37.9786 25.3623V22.8106L37.5483 22.3803C37.2071 22.0391 36.9846 21.9501 36.495 21.9501C36.0054 21.9501 35.7829 22.0391 35.4417 22.3803Z"
          className="fill-current"
        />
        <path
          d="M3.01163 24.8876C1.52807 25.4216 0.474746 26.5788 0.148363 28.092C0.0296787 28.5668 -0.014828 29.9317 0.0296787 31.7416C0.0741854 34.3081 0.103857 34.7087 0.385733 35.317C0.845635 36.2961 1.54291 37.0082 2.49238 37.483L3.33801 37.8984H6.67602C9.76182 37.8984 10.0734 37.8687 10.6965 37.5868C11.6756 37.1269 12.3877 36.4296 12.8625 35.4802L13.2778 34.6345V27.9585L12.8625 27.1129C12.3877 26.1634 11.6756 25.4661 10.6965 25.0062C10.0734 24.7244 9.70247 24.6947 6.89855 24.6502C4.19848 24.6205 3.67923 24.6502 3.01163 24.8876ZM9.56895 27.7657C10.2811 28.092 10.3849 28.5223 10.3849 31.2965C10.3849 35.0499 10.4294 35.0054 6.67602 35.0054C2.90778 35.0054 2.96712 35.0499 2.96712 31.2669C2.98196 28.5223 3.05614 28.1662 3.72374 27.7953C4.19848 27.5283 9.0052 27.5135 9.56895 27.7657Z"
          className="fill-current"
        />
        <path
          d="M5.94902 30.0207C4.65832 30.7328 5.20724 32.7801 6.67596 32.7801C7.43257 32.7801 8.15952 32.0531 8.15952 31.3114C8.15952 30.1987 6.92816 29.4717 5.94902 30.0207Z"
          className="fill-current"
        />
        <path
          d="M16.779 29.2787C16.1559 29.6199 16.0373 30.0501 16.0224 31.9936C16.0224 33.0914 16.0966 33.9519 16.2004 34.1892C16.4527 34.753 17.0609 35.0052 18.0994 35.0052H18.9895V35.8953C18.9895 36.9338 19.2417 37.5421 19.8055 37.7943C20.3692 38.0613 23.6331 38.0317 24.1672 37.7646C24.8644 37.3937 25.1018 36.5333 24.7161 35.7618C24.4342 35.2277 23.9001 35.0052 22.8468 35.0052H21.9567V34.1151C21.9567 32.5277 21.4522 32.0381 19.8797 32.0381H18.9895V31.148C18.9895 30.0946 18.767 29.5605 18.2329 29.2787C17.7285 29.0265 17.2389 29.0265 16.779 29.2787Z"
          className="fill-current"
        />
        <path
          d="M26.4218 30.7624C25.4279 31.3113 25.4575 32.8838 26.4812 33.3437C27.0004 33.5811 28.1131 33.5663 28.6175 33.3141C29.0329 33.0915 29.3741 32.5278 29.3741 32.0382C29.3741 31.5486 29.0329 30.9849 28.6175 30.7624C28.0983 30.4953 26.8966 30.4953 26.4218 30.7624Z"
          className="fill-current"
        />
        <path
          d="M33.0977 32.2459C32.5636 32.5426 32.3559 33.0618 32.341 34.0707V35.0053H30.7091C28.914 35.0053 28.4245 35.1537 28.0981 35.7619C27.6975 36.5334 27.9794 37.468 28.7063 37.7944C29.2404 38.0466 36.6285 38.0466 37.1626 37.7944C37.5928 37.6015 37.9786 36.9784 37.9786 36.4889C37.9786 35.9993 37.5928 35.3762 37.1626 35.1833C36.9549 35.0795 36.4505 35.0053 36.0499 35.0053H35.3082V34.1152C35.3082 33.0618 35.0856 32.5278 34.5515 32.2459C34.0471 31.9937 33.5576 31.9937 33.0977 32.2459Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default QRIcon;
