import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const ProgramacionIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M8.74685 0.72324C7.66135 0.81822 6.45825 1.15744 5.43154 1.65949C3.44597 2.63644 1.95792 4.12449 0.980968 6.11006C-1.34382 10.8501 0.605564 16.6168 5.32751 18.9869C6.73867 19.6924 8.05484 20 9.66953 20C11.2933 19.9955 12.6004 19.6924 14.0116 18.9869C17.7701 17.1008 19.8914 12.9668 19.2129 8.82382C18.6973 5.68038 16.7796 3.08421 13.9211 1.66853C12.3381 0.886065 10.5651 0.560413 8.74685 0.72324ZM10.0585 4.67629C10.2666 4.77579 10.5108 5.06074 10.5696 5.26879C10.6013 5.37734 10.6193 6.21861 10.6193 7.61167V9.78268L12.3381 10.642C13.4055 11.1757 14.1111 11.5512 14.1925 11.6371C14.6945 12.1527 14.4548 12.9985 13.7583 13.1749C13.6497 13.202 13.4914 13.2156 13.41 13.2065C13.3331 13.1975 12.3109 12.709 11.1395 12.121L9.01371 11.0491L8.87802 10.8275L8.74233 10.6059L8.72876 8.03231C8.71971 6.28645 8.73328 5.40448 8.76494 5.27784C8.82374 5.06526 9.06346 4.78031 9.27604 4.67629C9.46148 4.58583 9.86402 4.58583 10.0585 4.67629Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default ProgramacionIcon;
