import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const PrimariaIcon = ({ className, title }: IconProps) => {
  return (
    <div
      style={{ viewTransitionName: "Primaria-Icon" }}
      title={title}
      className="text-inherit"
    >
      <svg
        className={`text-inherit  ${className}`}
        viewBox="0 0 52 52"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M25.6784 0.504456C25.4384 0.544453 25.0784 0.764454 24.8784 1.00446C24.5384 1.36445 24.4984 1.90445 24.3984 6.44445L24.2984 11.4845L22.9184 13.0245L21.5384 14.5645H12.4984C3.75844 14.5645 3.45844 14.5845 3.09844 14.9645C2.85844 15.2245 2.37844 17.1445 1.57844 20.9045L0.418437 26.4645L0.398438 38.5845C0.398438 50.4845 0.398438 50.7045 0.798437 51.1245L1.21844 51.5645H25.9984H50.7784L51.1984 51.1245C51.5984 50.7045 51.5984 50.4845 51.5984 38.5845L51.5784 26.4645L50.4184 20.9045C49.6184 17.1445 49.1384 15.2245 48.8984 14.9645C48.5384 14.5845 48.2384 14.5645 39.4984 14.5645H30.4784L29.0384 12.9845C27.6984 11.5045 27.5984 11.3245 27.5984 10.4845V9.60445L31.5784 9.52445C35.1584 9.46445 35.5984 9.42445 35.9784 9.08445C36.6584 8.46445 36.5184 7.52445 35.5984 6.14445L34.7784 4.96445L35.5984 3.78445C36.5184 2.40445 36.6584 1.46445 35.9784 0.844456C35.5984 0.504456 35.1784 0.464455 30.8184 0.444454C28.2184 0.424454 25.8984 0.444454 25.6784 0.504456ZM31.9984 3.74445C31.9984 3.86445 31.9184 4.00446 31.7984 4.06445C31.6984 4.12445 31.5984 4.54445 31.5984 4.96445C31.5984 5.38445 31.6984 5.80445 31.7984 5.86445C32.3784 6.22445 31.7984 6.36445 29.7984 6.36445H27.5984V4.96445V3.56445H29.7984C31.0384 3.56445 31.9984 3.64445 31.9984 3.74445ZM32.2384 21.0645C35.5784 24.8045 38.5184 27.9645 38.7984 28.1045C39.1584 28.2845 40.5984 28.3645 43.9584 28.3645H48.5984V38.4645V48.5645H39.4984H30.3984V44.8845V41.1845L29.8784 40.7845C29.3784 40.4045 29.0784 40.3645 25.8984 40.3645C21.1784 40.3645 21.5184 40.0245 21.4384 44.8445L21.3784 48.5645H12.3784H3.39844V38.4645V28.3645H7.77844C10.1784 28.3645 12.4184 28.3045 12.7584 28.2445C13.2384 28.1445 14.6384 26.7245 19.6384 21.1445C23.0784 17.3045 25.9584 14.1845 26.0384 14.2245C26.1184 14.2445 28.8984 17.3245 32.2384 21.0645ZM18.0784 18.4045C17.6384 18.8845 16.0384 20.6445 14.5184 22.3045L11.7784 25.3645H7.77844C5.35844 25.3645 3.79844 25.2845 3.79844 25.1645C3.79844 24.9445 5.17844 18.1845 5.29844 17.8045C5.35844 17.6245 6.91844 17.5645 12.1384 17.5645H18.8784L18.0784 18.4045ZM47.4184 21.2645C47.8384 23.2445 48.1784 24.9845 48.1984 25.1045C48.1984 25.3045 47.2584 25.3645 44.1384 25.3645H40.0784L37.2984 22.2245C35.7584 20.5045 34.1984 18.7445 33.8384 18.3245L33.1584 17.5645L39.9184 17.6045L46.6784 17.6645L47.4184 21.2645ZM27.3984 45.9645V48.5645H25.8984H24.3984V45.9645V43.3645H25.8984H27.3984V45.9645Z"
          className="fill-current"
        />
        <path
          d="M24.4434 20.2228C22.6634 20.8828 21.5234 22.5228 21.5234 24.4628C21.5234 26.3828 22.4034 27.7228 24.2034 28.5428C26.3834 29.5428 29.0034 28.5028 30.0234 26.2628C31.6234 22.7828 28.0634 18.9228 24.4434 20.2228ZM26.8834 23.3828C27.9234 24.2028 27.2634 25.9628 25.9034 25.9628C25.1234 25.9628 24.5234 25.3028 24.5234 24.4628C24.5234 23.1228 25.8034 22.5428 26.8834 23.3828Z"
          className="fill-current"
        />
        <path
          d="M8.12156 32.7829C7.64156 33.1629 7.60156 33.3029 7.60156 34.8629C7.60156 36.4229 7.64156 36.5629 8.12156 36.9429C8.78156 37.4629 9.42156 37.4829 10.0216 36.9829C10.4616 36.6229 10.5016 36.4429 10.5016 34.8629C10.5016 33.2829 10.4616 33.1029 10.0216 32.7429C9.42156 32.2429 8.78156 32.2629 8.12156 32.7829Z"
          className="fill-current"
        />
        <path
          d="M14.1216 32.7829C13.6416 33.1629 13.6016 33.3029 13.6016 34.8629C13.6016 36.4229 13.6416 36.5629 14.1216 36.9429C14.7816 37.4629 15.4216 37.4829 16.0216 36.9829C16.4616 36.6229 16.5016 36.4429 16.5016 34.8629C16.5016 33.2829 16.4616 33.1029 16.0216 32.7429C15.4216 32.2429 14.7816 32.2629 14.1216 32.7829Z"
          className="fill-current"
        />
        <path
          d="M21.8984 32.8652C21.4584 33.2852 21.3984 33.5252 21.3984 34.8652C21.3984 36.2052 21.4584 36.4452 21.8984 36.8652C22.1584 37.1452 22.6184 37.3652 22.8984 37.3652C23.1784 37.3652 23.6384 37.1452 23.8984 36.8652C24.3384 36.4452 24.3984 36.2052 24.3984 34.8652C24.3984 33.5252 24.3384 33.2852 23.8984 32.8652C23.6384 32.5852 23.1784 32.3652 22.8984 32.3652C22.6184 32.3652 22.1584 32.5852 21.8984 32.8652Z"
          className="fill-current"
        />
        <path
          d="M28.1016 32.8652C27.6616 33.2852 27.6016 33.5252 27.6016 34.8652C27.6016 36.2052 27.6616 36.4452 28.1016 36.8652C28.3616 37.1452 28.8216 37.3652 29.1016 37.3652C29.3816 37.3652 29.8416 37.1452 30.1016 36.8652C30.5416 36.4452 30.6016 36.2052 30.6016 34.8652C30.6016 33.5252 30.5416 33.2852 30.1016 32.8652C29.8416 32.5852 29.3816 32.3652 29.1016 32.3652C28.8216 32.3652 28.3616 32.5852 28.1016 32.8652Z"
          className="fill-current"
        />
        <path
          d="M35.8326 32.5035C35.0526 32.8235 34.6926 35.4035 35.2926 36.5435C35.7726 37.4835 36.8526 37.6635 37.5526 36.9035C37.9326 36.5035 37.9926 36.2035 37.9926 34.8435C37.9926 33.4235 37.9326 33.1835 37.5326 32.8035C37.0926 32.3835 36.4126 32.2635 35.8326 32.5035Z"
          className="fill-current"
        />
        <path
          d="M41.8326 32.5035C41.0526 32.8235 40.6926 35.4035 41.2926 36.5435C41.7726 37.4835 42.8526 37.6635 43.5526 36.9035C43.9326 36.5035 43.9926 36.2035 43.9926 34.8435C43.9926 33.4235 43.9326 33.1835 43.5326 32.8035C43.0926 32.3835 42.4126 32.2635 41.8326 32.5035Z"
          className="fill-current"
        />
        <path
          d="M8.12156 40.7829C7.64156 41.1629 7.60156 41.3029 7.60156 42.8629C7.60156 44.4229 7.64156 44.5629 8.12156 44.9429C8.78156 45.4629 9.42156 45.4829 10.0216 44.9829C10.4616 44.6229 10.5016 44.4429 10.5016 42.8629C10.5016 41.2829 10.4616 41.1029 10.0216 40.7429C9.42156 40.2429 8.78156 40.2629 8.12156 40.7829Z"
          className="fill-current"
        />
        <path
          d="M14.1216 40.7829C13.6416 41.1629 13.6016 41.3029 13.6016 42.8629C13.6016 44.4229 13.6416 44.5629 14.1216 44.9429C14.7816 45.4629 15.4216 45.4829 16.0216 44.9829C16.4616 44.6229 16.5016 44.4429 16.5016 42.8629C16.5016 41.2829 16.4616 41.1029 16.0216 40.7429C15.4216 40.2429 14.7816 40.2629 14.1216 40.7829Z"
          className="fill-current"
        />
        <path
          d="M35.8326 40.5035C35.0526 40.8235 34.6926 43.4035 35.2926 44.5435C35.7726 45.4835 36.8526 45.6635 37.5526 44.9035C37.9326 44.5035 37.9926 44.2035 37.9926 42.8435C37.9926 41.4235 37.9326 41.1835 37.5326 40.8035C37.0926 40.3835 36.4126 40.2635 35.8326 40.5035Z"
          className="fill-current"
        />
        <path
          d="M41.8326 40.5035C41.0526 40.8235 40.6926 43.4035 41.2926 44.5435C41.7726 45.4835 42.8526 45.6635 43.5526 44.9035C43.9326 44.5035 43.9926 44.2035 43.9926 42.8435C43.9926 41.4235 43.9326 41.1835 43.5326 40.8035C43.0926 40.3835 42.4126 40.2635 41.8326 40.5035Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default PrimariaIcon;
