import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const OjoIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? "Mostrar Contraseña"}>
      <svg
        className={`${className}`}
        viewBox="0 0 255 152"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M111.523 0.871315C95.8686 3.7628 90.8833 4.95928 83.6047 7.45195C74.0329 10.842 60.2734 17.5223 51.8981 22.8068C36.9421 32.3786 18.8952 48.7305 6.83069 63.6864C-2.34231 75.1527 -2.34231 76.9474 7.22952 88.6131C33.1532 120.719 66.2558 142.155 101.053 149.434C113.716 152.126 141.235 152.126 153.898 149.434C182.813 143.352 209.833 128.097 233.464 104.466C243.933 93.9972 253.904 81.833 254.701 78.443C255.698 74.4547 254.402 71.663 247.722 63.487C222.297 31.9798 189.892 10.6426 155.892 3.06486C147.218 1.17043 117.904 -0.325164 111.523 0.871315ZM142.731 24.7012C159.681 29.8859 173.64 43.9445 179.024 61.2935C181.217 68.1732 181.217 83.8272 179.124 90.6072C173.64 108.156 159.681 122.214 142.232 127.598C135.253 129.792 119.699 129.792 112.719 127.598C85.7983 119.323 69.3467 92.1028 75.03 65.2817C79.2177 45.2407 95.9683 28.1909 115.81 23.6044C122.989 22.0091 135.552 22.5076 142.731 24.7012Z"
          className="fill-current"
        />
        <path
          d="M118.107 48.7307C111.028 51.0239 102.253 59.8978 100.16 67.0767C98.1655 73.8567 98.1655 78.2438 100.16 85.0238C102.353 92.5018 111.028 101.176 118.506 103.37C129.972 106.76 139.045 104.566 147.52 96.0913C153.702 89.8098 156.394 83.628 156.394 75.452C156.394 65.3817 148.916 54.1148 139.544 49.8274C133.661 47.2351 124.289 46.7365 118.107 48.7307Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default OjoIcon;
