import { IconProps } from "@/interfaces/IconProps";
import React from "react";

const LapizIcon = ({ className, title }: IconProps) => {
  return (
    <div title={title ?? ""}>
      <svg
        className={`${className}`}
        viewBox="0 0 22 22"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M16.8783 0.0613089C16.1415 0.223969 15.5196 0.597128 14.7541 1.37215L14.0078 2.11847L16.9261 5.03678L19.8444 7.95508L20.6099 7.18962C21.4519 6.34762 21.7963 5.77353 21.9494 4.91239C22.0834 4.23305 21.9494 3.46759 21.5954 2.75954C21.2127 2.00365 19.6626 0.530151 18.9641 0.27181C18.3231 0.0326042 17.4619 -0.0535097 16.8783 0.0613089Z"
          className="fill-current"
        />
        <path
          d="M6.66904 9.46546C3.39671 12.7378 0.660206 15.5604 0.574092 15.7326C0.459274 15.9431 0.344455 16.7564 0.210501 18.3256L0 20.6028L0.239205 21.0717C0.421001 21.4161 0.58366 21.5884 0.928116 21.7606L1.36825 21.9902L3.59765 21.7797C4.84151 21.6649 5.97056 21.5118 6.16192 21.4353C6.38199 21.3396 8.487 19.3111 12.4578 15.3403C15.7301 12.068 18.4092 9.3602 18.4092 9.3315C18.4092 9.29323 12.8118 3.65755 12.6396 3.53317C12.6205 3.5236 9.94137 6.19313 6.66904 9.46546Z"
          className="fill-current"
        />
      </svg>
    </div>
  );
};

export default LapizIcon;
